/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.recycler;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.recycler.Recycler;

public class ThreadLocalRecycler<T>
extends Recycler<T> {
    private final CloseableThreadLocal<Stack<T>> threadLocal = new CloseableThreadLocal<Stack<T>>(){

        @Override
        protected Stack<T> initialValue() {
            return new Stack(ThreadLocalRecycler.this.stackLimit, Thread.currentThread());
        }
    };
    final int stackLimit;

    public ThreadLocalRecycler(Recycler.C<T> c, int stackLimit) {
        super(c);
        this.stackLimit = stackLimit;
    }

    @Override
    public void close() {
        this.threadLocal.close();
    }

    @Override
    public Recycler.V<T> obtain(int sizing) {
        Stack<T> stack = this.threadLocal.get();
        T o = stack.pop();
        if (o == null) {
            o = this.c.newInstance(sizing);
        }
        return new TV<T>(stack, this.c, o);
    }

    static final class Stack<T> {
        final int stackLimit;
        final Thread thread;
        private T[] elements;
        private int size;

        Stack(int stackLimit, Thread thread) {
            this.stackLimit = stackLimit;
            this.thread = thread;
            this.elements = Stack.newArray(stackLimit < 10 ? stackLimit : 10);
        }

        T pop() {
            int size2 = this.size;
            if (size2 == 0) {
                return null;
            }
            T ret = this.elements[--size2];
            this.elements[size2] = null;
            this.size = size2;
            return ret;
        }

        void push(T o) {
            int size2 = this.size;
            if (size2 == this.elements.length) {
                if (size2 >= this.stackLimit) {
                    return;
                }
                T[] newElements = Stack.newArray(Math.min(this.stackLimit, ArrayUtil.oversize(size2 + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)));
                System.arraycopy(this.elements, 0, newElements, 0, size2);
                this.elements = newElements;
            }
            this.elements[size2] = o;
            this.size = size2 + 1;
        }

        private static <T> T[] newArray(int length) {
            return new Object[length];
        }
    }

    static class TV<T>
    implements Recycler.V<T> {
        final Stack<T> stack;
        final Recycler.C<T> c;
        T value;

        TV(Stack<T> stack, Recycler.C<T> c, T value2) {
            this.stack = stack;
            this.c = c;
            this.value = value2;
        }

        @Override
        public T v() {
            return this.value;
        }

        @Override
        public boolean isRecycled() {
            return true;
        }

        @Override
        public void release() {
            assert (Thread.currentThread() == this.stack.thread);
            if (this.value == null) {
                throw new ElasticSearchIllegalStateException("recycler entry already released...");
            }
            this.c.clear(this.value);
            this.stack.push(this.value);
            this.value = null;
        }
    }
}

