/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.recycler;

import java.lang.ref.SoftReference;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.recycler.ThreadLocalRecycler;

public class SoftThreadLocalRecycler<T>
extends Recycler<T> {
    private final CloseableThreadLocal<SoftReference<ThreadLocalRecycler.Stack<T>>> threadLocal = new CloseableThreadLocal();
    final int stackLimit;

    public SoftThreadLocalRecycler(Recycler.C<T> c, int stackLimit) {
        super(c);
        this.stackLimit = stackLimit;
    }

    @Override
    public void close() {
        this.threadLocal.close();
    }

    @Override
    public Recycler.V<T> obtain(int sizing) {
        T o;
        ThreadLocalRecycler.Stack<T> stack;
        SoftReference<ThreadLocalRecycler.Stack<T>> ref = this.threadLocal.get();
        ThreadLocalRecycler.Stack<T> stack2 = stack = ref == null ? null : ref.get();
        if (stack == null) {
            stack = new ThreadLocalRecycler.Stack(this.stackLimit, Thread.currentThread());
            this.threadLocal.set(new SoftReference<ThreadLocalRecycler.Stack<T>>(stack));
        }
        if ((o = stack.pop()) == null) {
            o = this.c.newInstance(sizing);
        }
        return new ThreadLocalRecycler.TV<T>(stack, this.c, o);
    }
}

