/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.recycler;

import org.elasticsearch.common.recycler.NoneRecycler;

public abstract class Recycler<T> {
    protected final C<T> c;

    protected Recycler(C<T> c) {
        this.c = c;
    }

    public abstract void close();

    public V<T> obtain() {
        return this.obtain(-1);
    }

    public abstract V<T> obtain(int var1);

    public static interface V<T> {
        public T v();

        public boolean isRecycled();

        public void release();
    }

    public static interface C<T> {
        public T newInstance(int var1);

        public void clear(T var1);
    }

    public static class Sizing<T>
    extends Recycler<T> {
        private final Recycler<T> recycler;
        private final int smartSize;

        public Sizing(Recycler<T> recycler, int smartSize) {
            super(recycler.c);
            this.recycler = recycler;
            this.smartSize = smartSize;
        }

        @Override
        public void close() {
            this.recycler.close();
        }

        @Override
        public V<T> obtain(int sizing) {
            if (sizing > 0 && sizing < this.smartSize) {
                return new NoneRecycler.NV(this.c.newInstance(sizing));
            }
            return this.recycler.obtain(sizing);
        }
    }
}

