/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.recycler;

import java.util.Queue;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public class QueueRecycler<T>
extends Recycler<T> {
    final Queue<T> queue;

    public QueueRecycler(Recycler.C<T> c) {
        this(c, ConcurrentCollections.newQueue());
    }

    public QueueRecycler(Recycler.C<T> c, Queue<T> queue) {
        super(c);
        this.queue = queue;
    }

    @Override
    public void close() {
        this.queue.clear();
    }

    @Override
    public Recycler.V<T> obtain(int sizing) {
        T v = this.queue.poll();
        if (v == null) {
            v = this.c.newInstance(sizing);
        }
        return new QV(v);
    }

    class QV
    implements Recycler.V<T> {
        T value;

        QV(T value2) {
            this.value = value2;
        }

        @Override
        public T v() {
            return this.value;
        }

        @Override
        public boolean isRecycled() {
            return true;
        }

        @Override
        public void release() {
            if (this.value == null) {
                throw new ElasticSearchIllegalStateException("recycler entry already released...");
            }
            QueueRecycler.this.c.clear(this.value);
            QueueRecycler.this.queue.offer(this.value);
            this.value = null;
        }
    }
}

