/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.recycler;

import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.recycler.Recycler;

public class NoneRecycler<T>
extends Recycler<T> {
    public NoneRecycler(Recycler.C<T> c) {
        super(c);
    }

    @Override
    public Recycler.V<T> obtain(int sizing) {
        return new NV(this.c.newInstance(sizing));
    }

    @Override
    public void close() {
    }

    public static class NV<T>
    implements Recycler.V<T> {
        T value;

        NV(T value2) {
            this.value = value2;
        }

        @Override
        public T v() {
            return this.value;
        }

        @Override
        public boolean isRecycled() {
            return false;
        }

        @Override
        public void release() {
            if (this.value == null) {
                throw new ElasticSearchIllegalStateException("recycler entry already released...");
            }
            this.value = null;
        }
    }
}

