/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.path;

import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;

public class PathTrie<T> {
    public static final Decoder NO_DECODER = new Decoder(){

        @Override
        public String decode(String value2) {
            return value2;
        }
    };
    private final Decoder decoder;
    private final TrieNode<T> root;
    private final char separator;
    private T rootValue;

    public PathTrie() {
        this('/', "*", NO_DECODER);
    }

    public PathTrie(Decoder decoder2) {
        this('/', "*", decoder2);
    }

    public PathTrie(char separator, String wildcard, Decoder decoder2) {
        this.decoder = decoder2;
        this.separator = separator;
        this.root = new TrieNode<Object>(new String(new char[]{separator}), null, null, wildcard);
    }

    public void insert(String path, T value2) {
        String[] strings = Strings.splitStringToArray(path, this.separator);
        if (strings.length == 0) {
            this.rootValue = value2;
            return;
        }
        int index = 0;
        if (strings.length > 0 && strings[0].isEmpty()) {
            index = 1;
        }
        this.root.insert(strings, index, value2);
    }

    public T retrieve(String path) {
        return this.retrieve(path, null);
    }

    public T retrieve(String path, Map<String, String> params) {
        if (path.length() == 0) {
            return this.rootValue;
        }
        String[] strings = Strings.splitStringToArray(path, this.separator);
        if (strings.length == 0) {
            return this.rootValue;
        }
        int index = 0;
        if (strings.length > 0 && strings[0].isEmpty()) {
            index = 1;
        }
        return this.root.retrieve(strings, index, params);
    }

    public class TrieNode<T> {
        private transient String key;
        private transient T value;
        private boolean isWildcard;
        private final String wildcard;
        private transient String namedWildcard;
        private ImmutableMap<String, TrieNode<T>> children;
        private final TrieNode parent;

        public TrieNode(String key, T value2, TrieNode parent, String wildcard) {
            this.key = key;
            this.wildcard = wildcard;
            this.isWildcard = key.equals(wildcard);
            this.parent = parent;
            this.value = value2;
            this.children = ImmutableMap.of();
            this.namedWildcard = this.isNamedWildcard(key) ? key.substring(key.indexOf(123) + 1, key.indexOf(125)) : null;
        }

        public void updateKeyWithNamedWildcard(String key) {
            this.key = key;
            this.namedWildcard = key.substring(key.indexOf(123) + 1, key.indexOf(125));
        }

        public boolean isWildcard() {
            return this.isWildcard;
        }

        public synchronized void addChild(TrieNode<T> child) {
            this.children = MapBuilder.newMapBuilder(this.children).put(child.key, child).immutableMap();
        }

        public TrieNode getChild(String key) {
            return this.children.get(key);
        }

        public synchronized void insert(String[] path, int index, T value2) {
            TrieNode<Object> node;
            String token2;
            if (index >= path.length) {
                return;
            }
            String key = token2 = path[index];
            if (this.isNamedWildcard(token2)) {
                key = this.wildcard;
            }
            if ((node = this.children.get(key)) == null) {
                node = index == path.length - 1 ? new TrieNode<T>(token2, value2, this, this.wildcard) : new TrieNode<Object>(token2, null, this, this.wildcard);
                this.children = MapBuilder.newMapBuilder(this.children).put(key, node).immutableMap();
            } else {
                if (this.isNamedWildcard(token2)) {
                    node.updateKeyWithNamedWildcard(token2);
                }
                if (index == path.length - 1) {
                    assert (node.value == null || node.value == value2);
                    if (node.value == null) {
                        node.value = value2;
                    }
                }
            }
            node.insert(path, index + 1, value2);
        }

        private boolean isNamedWildcard(String key) {
            return key.indexOf(123) != -1 && key.indexOf(125) != -1;
        }

        private String namedWildcard() {
            return this.namedWildcard;
        }

        private boolean isNamedWildcard() {
            return this.namedWildcard != null;
        }

        public T retrieve(String[] path, int index, Map<String, String> params) {
            if (index >= path.length) {
                return null;
            }
            String token2 = path[index];
            TrieNode<T> node = this.children.get(token2);
            boolean usedWildcard = false;
            if (node == null) {
                node = this.children.get(this.wildcard);
                if (node == null) {
                    return null;
                }
                usedWildcard = true;
                if (params != null && super.isNamedWildcard()) {
                    this.put(params, super.namedWildcard(), token2);
                }
            }
            if (index == path.length - 1) {
                if (params != null && super.isNamedWildcard()) {
                    this.put(params, super.namedWildcard(), token2);
                }
                return node.value;
            }
            T res = node.retrieve(path, index + 1, params);
            if (res == null && !usedWildcard && (node = this.children.get(this.wildcard)) != null) {
                if (params != null && super.isNamedWildcard()) {
                    this.put(params, super.namedWildcard(), token2);
                }
                res = node.retrieve(path, index + 1, params);
            }
            return res;
        }

        private void put(Map<String, String> params, String key, String value2) {
            params.put(key, PathTrie.this.decoder.decode(value2));
        }
    }

    public static interface Decoder {
        public String decode(String var1);
    }
}

