/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.replay;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBufferFactory;
import org.elasticsearch.common.netty.buffer.ChannelBufferIndexFinder;
import org.elasticsearch.common.netty.handler.codec.replay.ReplayError;
import org.elasticsearch.common.netty.handler.codec.replay.ReplayingDecoder;
import org.elasticsearch.common.netty.handler.codec.replay.UnreplayableOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplayingDecoderBuffer
implements ChannelBuffer {
    private static final Error REPLAY = new ReplayError();
    private final ReplayingDecoder<?> parent;
    private boolean terminated;

    ReplayingDecoderBuffer(ReplayingDecoder<?> parent) {
        this.parent = parent;
    }

    private ChannelBuffer buf() {
        return this.parent.internalBuffer();
    }

    void terminate() {
        this.terminated = true;
    }

    @Override
    public int capacity() {
        if (this.terminated) {
            return this.buf().capacity();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isDirect() {
        return this.buf().isDirect();
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnreplayableOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(ChannelBuffer buffer) {
        throw new UnreplayableOperationException();
    }

    @Override
    public ChannelBuffer copy() {
        throw new UnreplayableOperationException();
    }

    @Override
    public ChannelBuffer copy(int index, int length) {
        this.checkIndex(index, length);
        return this.buf().copy(index, length);
    }

    @Override
    public void discardReadBytes() {
        throw new UnreplayableOperationException();
    }

    @Override
    public void ensureWritableBytes(int writableBytes) {
        throw new UnreplayableOperationException();
    }

    @Override
    public ChannelBuffer duplicate() {
        throw new UnreplayableOperationException();
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index, 1);
        return this.buf().getByte(index);
    }

    @Override
    public short getUnsignedByte(int index) {
        this.checkIndex(index, 1);
        return this.buf().getUnsignedByte(index);
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buf().getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        this.checkIndex(index, dst.length);
        this.buf().getBytes(index, dst);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buf().getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, ChannelBuffer dst, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void getBytes(int index, ChannelBuffer dst) {
        throw new UnreplayableOperationException();
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index, 4);
        return this.buf().getInt(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        this.checkIndex(index, 4);
        return this.buf().getUnsignedInt(index);
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index, 8);
        return this.buf().getLong(index);
    }

    @Override
    public int getMedium(int index) {
        this.checkIndex(index, 3);
        return this.buf().getMedium(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        this.checkIndex(index, 3);
        return this.buf().getUnsignedMedium(index);
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index, 2);
        return this.buf().getShort(index);
    }

    @Override
    public int getUnsignedShort(int index) {
        this.checkIndex(index, 2);
        return this.buf().getUnsignedShort(index);
    }

    @Override
    public char getChar(int index) {
        this.checkIndex(index, 2);
        return this.buf().getChar(index);
    }

    @Override
    public float getFloat(int index) {
        this.checkIndex(index, 4);
        return this.buf().getFloat(index);
    }

    @Override
    public double getDouble(int index) {
        this.checkIndex(index, 8);
        return this.buf().getDouble(index);
    }

    @Override
    public int hashCode() {
        throw new UnreplayableOperationException();
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, byte value2) {
        int endIndex = this.buf().indexOf(fromIndex, toIndex, value2);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return endIndex;
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        int endIndex = this.buf().indexOf(fromIndex, toIndex, indexFinder);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return endIndex;
    }

    @Override
    public int bytesBefore(byte value2) {
        int bytes = this.buf().bytesBefore(value2);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public int bytesBefore(ChannelBufferIndexFinder indexFinder) {
        int bytes = this.buf().bytesBefore(indexFinder);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public int bytesBefore(int length, byte value2) {
        this.checkReadableBytes(length);
        int bytes = this.buf().bytesBefore(length, value2);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public int bytesBefore(int length, ChannelBufferIndexFinder indexFinder) {
        this.checkReadableBytes(length);
        int bytes = this.buf().bytesBefore(length, indexFinder);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public int bytesBefore(int index, int length, byte value2) {
        int bytes = this.buf().bytesBefore(index, length, value2);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public int bytesBefore(int index, int length, ChannelBufferIndexFinder indexFinder) {
        int bytes = this.buf().bytesBefore(index, length, indexFinder);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public void markReaderIndex() {
        this.buf().markReaderIndex();
    }

    @Override
    public void markWriterIndex() {
        throw new UnreplayableOperationException();
    }

    @Override
    public ChannelBufferFactory factory() {
        return this.buf().factory();
    }

    @Override
    public ByteOrder order() {
        return this.buf().order();
    }

    @Override
    public boolean readable() {
        return this.terminated ? this.buf().readable() : true;
    }

    @Override
    public int readableBytes() {
        if (this.terminated) {
            return this.buf().readableBytes();
        }
        return Integer.MAX_VALUE - this.buf().readerIndex();
    }

    @Override
    public byte readByte() {
        this.checkReadableBytes(1);
        return this.buf().readByte();
    }

    @Override
    public short readUnsignedByte() {
        this.checkReadableBytes(1);
        return this.buf().readUnsignedByte();
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.buf().readBytes(dst, dstIndex, length);
    }

    @Override
    public void readBytes(byte[] dst) {
        this.checkReadableBytes(dst.length);
        this.buf().readBytes(dst);
    }

    @Override
    public void readBytes(ByteBuffer dst) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void readBytes(ChannelBuffer dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.buf().readBytes(dst, dstIndex, length);
    }

    @Override
    public void readBytes(ChannelBuffer dst, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void readBytes(ChannelBuffer dst) {
        throw new UnreplayableOperationException();
    }

    @Override
    @Deprecated
    public ChannelBuffer readBytes(ChannelBufferIndexFinder endIndexFinder) {
        int endIndex = this.buf().indexOf(this.buf().readerIndex(), this.buf().writerIndex(), endIndexFinder);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return this.buf().readBytes(endIndex - this.buf().readerIndex());
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public ChannelBuffer readBytes(int length) {
        this.checkReadableBytes(length);
        return this.buf().readBytes(length);
    }

    @Override
    @Deprecated
    public ChannelBuffer readSlice(ChannelBufferIndexFinder endIndexFinder) {
        int endIndex = this.buf().indexOf(this.buf().readerIndex(), this.buf().writerIndex(), endIndexFinder);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return this.buf().readSlice(endIndex - this.buf().readerIndex());
    }

    @Override
    public ChannelBuffer readSlice(int length) {
        this.checkReadableBytes(length);
        return this.buf().readSlice(length);
    }

    @Override
    public void readBytes(OutputStream out, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public int readerIndex() {
        return this.buf().readerIndex();
    }

    @Override
    public void readerIndex(int readerIndex) {
        this.buf().readerIndex(readerIndex);
    }

    @Override
    public int readInt() {
        this.checkReadableBytes(4);
        return this.buf().readInt();
    }

    @Override
    public long readUnsignedInt() {
        this.checkReadableBytes(4);
        return this.buf().readUnsignedInt();
    }

    @Override
    public long readLong() {
        this.checkReadableBytes(8);
        return this.buf().readLong();
    }

    @Override
    public int readMedium() {
        this.checkReadableBytes(3);
        return this.buf().readMedium();
    }

    @Override
    public int readUnsignedMedium() {
        this.checkReadableBytes(3);
        return this.buf().readUnsignedMedium();
    }

    @Override
    public short readShort() {
        this.checkReadableBytes(2);
        return this.buf().readShort();
    }

    @Override
    public int readUnsignedShort() {
        this.checkReadableBytes(2);
        return this.buf().readUnsignedShort();
    }

    @Override
    public char readChar() {
        this.checkReadableBytes(2);
        return this.buf().readChar();
    }

    @Override
    public float readFloat() {
        this.checkReadableBytes(4);
        return this.buf().readFloat();
    }

    @Override
    public double readDouble() {
        this.checkReadableBytes(8);
        return this.buf().readDouble();
    }

    @Override
    public void resetReaderIndex() {
        this.buf().resetReaderIndex();
    }

    @Override
    public void resetWriterIndex() {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setByte(int index, int value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setBytes(int index, byte[] src) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setBytes(int index, ChannelBuffer src, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setBytes(int index, ChannelBuffer src) {
        throw new UnreplayableOperationException();
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setZero(int index, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setIndex(int readerIndex, int writerIndex) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setInt(int index, int value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setLong(int index, long value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setMedium(int index, int value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setShort(int index, int value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setChar(int index, int value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setFloat(int index, float value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setDouble(int index, double value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    @Deprecated
    public int skipBytes(ChannelBufferIndexFinder firstIndexFinder) {
        int oldReaderIndex = this.buf().readerIndex();
        int newReaderIndex = this.buf().indexOf(oldReaderIndex, this.buf().writerIndex(), firstIndexFinder);
        if (newReaderIndex < 0) {
            throw REPLAY;
        }
        this.buf().readerIndex(newReaderIndex);
        return newReaderIndex - oldReaderIndex;
    }

    @Override
    public void skipBytes(int length) {
        this.checkReadableBytes(length);
        this.buf().skipBytes(length);
    }

    @Override
    public ChannelBuffer slice() {
        throw new UnreplayableOperationException();
    }

    @Override
    public ChannelBuffer slice(int index, int length) {
        this.checkIndex(index, length);
        return this.buf().slice(index, length);
    }

    @Override
    public ByteBuffer toByteBuffer() {
        throw new UnreplayableOperationException();
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        this.checkIndex(index, length);
        return this.buf().toByteBuffer(index, length);
    }

    @Override
    public ByteBuffer[] toByteBuffers() {
        throw new UnreplayableOperationException();
    }

    @Override
    public ByteBuffer[] toByteBuffers(int index, int length) {
        this.checkIndex(index, length);
        return this.buf().toByteBuffers(index, length);
    }

    @Override
    public String toString(int index, int length, Charset charset) {
        this.checkIndex(index, length);
        return this.buf().toString(index, length, charset);
    }

    @Override
    public String toString(Charset charsetName) {
        throw new UnreplayableOperationException();
    }

    @Override
    @Deprecated
    public String toString(int index, int length, String charsetName) {
        this.checkIndex(index, length);
        return this.buf().toString(index, length, charsetName);
    }

    @Override
    @Deprecated
    public String toString(int index, int length, String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        this.checkIndex(index, length);
        return this.buf().toString(index, length, charsetName, terminatorFinder);
    }

    @Override
    @Deprecated
    public String toString(String charsetName) {
        throw new UnreplayableOperationException();
    }

    @Override
    @Deprecated
    public String toString(String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        throw new UnreplayableOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '(' + "ridx=" + this.readerIndex() + ", " + "widx=" + this.writerIndex() + ')';
    }

    @Override
    public boolean writable() {
        return false;
    }

    @Override
    public int writableBytes() {
        return 0;
    }

    @Override
    public void writeByte(int value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeBytes(byte[] src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeBytes(byte[] src) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeBytes(ByteBuffer src) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeBytes(ChannelBuffer src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeBytes(ChannelBuffer src, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeBytes(ChannelBuffer src) {
        throw new UnreplayableOperationException();
    }

    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeInt(int value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeLong(long value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeMedium(int value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeZero(int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public int writerIndex() {
        return this.buf().writerIndex();
    }

    @Override
    public void writerIndex(int writerIndex) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeShort(int value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeChar(int value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeFloat(float value2) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeDouble(double value2) {
        throw new UnreplayableOperationException();
    }

    private void checkIndex(int index, int length) {
        if (index + length > this.buf().writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkReadableBytes(int readableBytes) {
        if (this.buf().readableBytes() < readableBytes) {
            throw REPLAY;
        }
    }
}

