/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Field;
import org.elasticsearch.common.mvel2.OptimizationFailure;
import org.elasticsearch.common.mvel2.compiler.AccessorNode;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;

public class StaticVarAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    Field field;

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.field.get(null), elCtx, vars);
            }
            return this.field.get(null);
        }
        catch (Exception e) {
            throw new OptimizationFailure("unable to access static field", e);
        }
    }

    public StaticVarAccessor(Field field2) {
        this.field = field2;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value2) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.setValue(this.field.get(null), elCtx, variableFactory, value2);
            }
            this.field.set(null, value2);
        }
        catch (Exception e) {
            throw new RuntimeException("error accessing static variable", e);
        }
        return value2;
    }

    public Field getField() {
        return this.field;
    }

    public Class getKnownEgressType() {
        return this.field.getClass();
    }
}

