/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Method;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.compiler.AccessorNode;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ParseTools;
import org.elasticsearch.common.mvel2.util.ReflectionUtil;

public class GetterAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private final Method method;
    public static final Object[] EMPTY = new Object[0];

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.method.invoke(ctx, EMPTY), elCtx, vars);
            }
            return this.method.invoke(ctx, EMPTY);
        }
        catch (IllegalArgumentException e) {
            Method o;
            if (ctx != null && this.method.getDeclaringClass() != ctx.getClass() && (o = ParseTools.getBestCandidate(EMPTY, this.method.getName(), ctx.getClass(), ctx.getClass().getMethods(), true)) != null) {
                return this.executeOverrideTarget(o, ctx, elCtx, vars);
            }
            if (this.nextNode != null) {
                return this.nextNode.getValue(MVEL.getProperty(ReflectionUtil.getPropertyFromAccessor(this.method.getName()), ctx), elCtx, vars);
            }
            return MVEL.getProperty(ReflectionUtil.getPropertyFromAccessor(this.method.getName()), ctx);
        }
        catch (NullPointerException e) {
            if (ctx == null) {
                throw new RuntimeException("unable to invoke method: " + this.method.getDeclaringClass().getName() + "." + this.method.getName() + ": " + "target of method is null", e);
            }
            throw new RuntimeException("cannot invoke getter: " + this.method.getName() + " (see trace)", e);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot invoke getter: " + this.method.getName() + " [declr.class: " + this.method.getDeclaringClass().getName() + "; act.class: " + (ctx != null ? ctx.getClass().getName() : "null") + "] (see trace)", e);
        }
    }

    public GetterAccessor(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public String toString() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory vars, Object value2) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.setValue(this.method.invoke(ctx, EMPTY), elCtx, vars, value2);
            }
            throw new RuntimeException("bad payload");
        }
        catch (IllegalArgumentException e) {
            if (this.nextNode != null) {
                return this.nextNode.setValue(MVEL.getProperty(ReflectionUtil.getPropertyFromAccessor(this.method.getName()), ctx), elCtx, vars, value2);
            }
            return MVEL.getProperty(ReflectionUtil.getPropertyFromAccessor(this.method.getName()), ctx);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("error " + this.method.getName() + ": " + e.getClass().getName() + ":" + e.getMessage(), e);
        }
    }

    public Class getKnownEgressType() {
        return this.method.getReturnType();
    }

    private Object executeOverrideTarget(Method o, Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(o.invoke(ctx, EMPTY), elCtx, vars);
            }
            return o.invoke(ctx, EMPTY);
        }
        catch (Exception e2) {
            throw new RuntimeException("unable to invoke method", e2);
        }
    }
}

