/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Field;
import org.elasticsearch.common.mvel2.DataConversion;
import org.elasticsearch.common.mvel2.compiler.AccessorNode;
import org.elasticsearch.common.mvel2.integration.PropertyHandler;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;

public class FieldAccessorNH
implements AccessorNode {
    private AccessorNode nextNode;
    private Field field;
    private boolean coercionRequired = false;
    private PropertyHandler nullHandler;

    public FieldAccessorNH(Field field2, PropertyHandler handler) {
        this.field = field2;
        this.nullHandler = handler;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            Object v = this.field.get(ctx);
            if (v == null) {
                v = this.nullHandler.getProperty(this.field.getName(), elCtx, vars);
            }
            if (this.nextNode != null) {
                return this.nextNode.getValue(v, elCtx, vars);
            }
            return v;
        }
        catch (Exception e) {
            throw new RuntimeException("unable to access field", e);
        }
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value2) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.setValue(ctx, elCtx, variableFactory, value2);
            }
            if (this.coercionRequired) {
                value2 = DataConversion.convert(ctx, this.field.getClass());
                this.field.set(ctx, value2);
                return value2;
            }
            this.field.set(ctx, value2);
            return value2;
        }
        catch (IllegalArgumentException e) {
            if (!this.coercionRequired) {
                this.coercionRequired = true;
                return this.setValue(ctx, elCtx, variableFactory, value2);
            }
            throw new RuntimeException("unable to bind property", e);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to access field", e);
        }
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field2) {
        this.field = field2;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public Class getKnownEgressType() {
        return this.field.getClass();
    }
}

