/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.integration.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.mvel2.UnresolveablePropertyException;
import org.elasticsearch.common.mvel2.integration.VariableResolver;
import org.elasticsearch.common.mvel2.integration.impl.BaseVariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.SimpleSTValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingMapVariableResolverFactory
extends BaseVariableResolverFactory {
    protected Map<String, Object> variables;

    public CachingMapVariableResolverFactory(Map variables) {
        this.variables = variables;
    }

    @Override
    public VariableResolver createVariable(String name, Object value2) {
        try {
            VariableResolver vr = this.getVariableResolver(name);
            vr.setValue(value2);
            return vr;
        }
        catch (UnresolveablePropertyException e) {
            SimpleSTValueResolver vr = new SimpleSTValueResolver(value2, null, true);
            this.addResolver(name, vr);
            return vr;
        }
    }

    @Override
    public VariableResolver createVariable(String name, Object value2, Class<?> type) {
        VariableResolver vr;
        try {
            vr = this.getVariableResolver(name);
        }
        catch (UnresolveablePropertyException e) {
            vr = null;
        }
        if (vr != null && vr.getType() != null) {
            throw new RuntimeException("variable already defined within scope: " + vr.getType() + " " + name);
        }
        vr = new SimpleSTValueResolver(value2, type, true);
        this.addResolver(name, vr);
        return vr;
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        VariableResolver vr = (VariableResolver)this.variableResolvers.get(name);
        if (vr != null) {
            return vr;
        }
        if (this.variables.containsKey(name)) {
            vr = new SimpleSTValueResolver(this.variables.get(name), null);
            this.variableResolvers.put(name, vr);
            return vr;
        }
        if (this.nextFactory != null) {
            return this.nextFactory.getVariableResolver(name);
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + name + "'");
    }

    @Override
    public boolean isResolveable(String name) {
        return this.variableResolvers.containsKey(name) || this.variables != null && this.variables.containsKey(name) || this.nextFactory != null && this.nextFactory.isResolveable(name);
    }

    protected VariableResolver addResolver(String name, VariableResolver vr) {
        this.variableResolvers.put(name, vr);
        return vr;
    }

    public void externalize() {
        for (Map.Entry entry2 : this.variableResolvers.entrySet()) {
            if (((VariableResolver)entry2.getValue()).getFlags() != -1) continue;
            this.variables.put((String)entry2.getKey(), ((VariableResolver)entry2.getValue()).getValue());
        }
    }

    @Override
    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }

    @Override
    public Set<String> getKnownVariables() {
        if (this.nextFactory == null) {
            if (this.variables != null) {
                return new HashSet<String>(this.variables.keySet());
            }
            return new HashSet<String>(0);
        }
        if (this.variables != null) {
            return new HashSet<String>(this.variables.keySet());
        }
        return new HashSet<String>(0);
    }

    public void clear() {
        this.variableResolvers.clear();
        this.variables.clear();
    }
}

