/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.compiler;

import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.ast.TypeCast;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;

public class ExecutableAccessor
implements ExecutableStatement {
    private ASTNode node;
    private Class ingress;
    private Class egress;
    private boolean convertable;

    public ExecutableAccessor(ASTNode node, Class egress) {
        this.node = node;
        this.egress = egress;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        return this.node.getReducedValueAccelerated(ctx, elCtx, variableFactory);
    }

    public Object getValue(Object staticContext, VariableResolverFactory factory) {
        return this.node.getReducedValueAccelerated(staticContext, staticContext, factory);
    }

    public void setKnownIngressType(Class type) {
        this.ingress = type;
    }

    public void setKnownEgressType(Class type) {
        this.egress = type;
    }

    public Class getKnownIngressType() {
        return this.ingress;
    }

    public Class getKnownEgressType() {
        return this.egress;
    }

    public boolean isConvertableIngressEgress() {
        return this.convertable;
    }

    public void computeTypeConversionRule() {
        if (this.ingress != null && this.egress != null) {
            this.convertable = this.ingress.isAssignableFrom(this.egress);
        }
    }

    public boolean intOptimized() {
        return false;
    }

    public ASTNode getNode() {
        return this.node;
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value2) {
        return null;
    }

    public boolean isLiteralOnly() {
        return false;
    }

    public boolean isExplicitCast() {
        return this.node instanceof TypeCast;
    }

    public boolean isEmptyStatement() {
        return this.node == null;
    }

    public String toString() {
        return this.node.toString();
    }
}

