/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.CompilerTools;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class Strsim
extends ASTNode {
    private ASTNode stmt;
    private ASTNode soundslike;

    public Strsim(ASTNode stmt, ASTNode clsStmt, ParserContext pCtx) {
        super(pCtx);
        this.stmt = stmt;
        this.soundslike = clsStmt;
        CompilerTools.expectType(clsStmt, String.class, true);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return Float.valueOf(ParseTools.similarity(String.valueOf(this.soundslike.getReducedValueAccelerated(ctx, thisValue, factory)), (String)this.stmt.getReducedValueAccelerated(ctx, thisValue, factory)));
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            String i = String.valueOf(this.soundslike.getReducedValue(ctx, thisValue, factory));
            if (i == null) {
                throw new ClassCastException();
            }
            String x2 = (String)this.stmt.getReducedValue(ctx, thisValue, factory);
            if (x2 == null) {
                throw new CompileException("not a string: " + this.stmt.getName(), this.stmt.getExpr(), this.getStart());
            }
            return Float.valueOf(ParseTools.similarity(i, x2));
        }
        catch (ClassCastException e) {
            throw new CompileException("not a string: " + this.soundslike.getName(), this.soundslike.getExpr(), this.soundslike.getStart());
        }
    }

    public Class getEgressType() {
        return Boolean.class;
    }
}

