/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;

public class UidField
extends Field {
    private String uid;
    private long version;

    public static DocIdAndVersion loadDocIdAndVersion(AtomicReaderContext context, Term term) {
        int docId = -1;
        try {
            Terms terms = context.reader().terms(term.field());
            if (terms == null) {
                return null;
            }
            TermsEnum termsEnum = terms.iterator(null);
            if (termsEnum == null) {
                return null;
            }
            if (!termsEnum.seekExact(term.bytes())) {
                return null;
            }
            DocsAndPositionsEnum uid = termsEnum.docsAndPositions(context.reader().getLiveDocs(), null, 2);
            if (uid == null || uid.nextDoc() == Integer.MAX_VALUE) {
                return null;
            }
            do {
                docId = uid.docID();
                uid.nextPosition();
                if (uid.getPayload() == null || uid.getPayload().length < 8) continue;
                byte[] payload = new byte[uid.getPayload().length];
                System.arraycopy(uid.getPayload().bytes, uid.getPayload().offset, payload, 0, uid.getPayload().length);
                return new DocIdAndVersion(docId, Numbers.bytesToLong(payload), context);
            } while (uid.nextDoc() != Integer.MAX_VALUE);
            return new DocIdAndVersion(docId, -2L, context);
        }
        catch (Exception e) {
            return new DocIdAndVersion(docId, -2L, context);
        }
    }

    public static long loadVersion(AtomicReaderContext context, Term term) {
        try {
            Terms terms = context.reader().terms(term.field());
            if (terms == null) {
                return -1L;
            }
            TermsEnum termsEnum = terms.iterator(null);
            if (termsEnum == null) {
                return -1L;
            }
            if (!termsEnum.seekExact(term.bytes())) {
                return -1L;
            }
            DocsAndPositionsEnum uid = termsEnum.docsAndPositions(context.reader().getLiveDocs(), null, 2);
            if (uid == null || uid.nextDoc() == Integer.MAX_VALUE) {
                return -1L;
            }
            do {
                uid.nextPosition();
                if (uid.getPayload() == null || uid.getPayload().length < 8) continue;
                byte[] payload = new byte[uid.getPayload().length];
                System.arraycopy(uid.getPayload().bytes, uid.getPayload().offset, payload, 0, uid.getPayload().length);
                return Numbers.bytesToLong(payload);
            } while (uid.nextDoc() != Integer.MAX_VALUE);
            return -2L;
        }
        catch (Exception e) {
            return -2L;
        }
    }

    public UidField(String uid) {
        this(UidFieldMapper.NAME, uid, 0L);
    }

    public UidField(String name, String uid, long version) {
        super(name, UidFieldMapper.Defaults.FIELD_TYPE);
        this.uid = uid;
        this.version = version;
        this.tokenStream = new UidPayloadTokenStream(this);
    }

    public String uid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    @Override
    public String stringValue() {
        return this.uid;
    }

    @Override
    public Reader readerValue() {
        return null;
    }

    public long version() {
        return this.version;
    }

    public void version(long version) {
        this.version = version;
    }

    @Override
    public TokenStream tokenStream(Analyzer analyzer) throws IOException {
        return this.tokenStream;
    }

    public static final class UidPayloadTokenStream
    extends TokenStream {
        private final PayloadAttribute payloadAttribute = this.addAttribute(PayloadAttribute.class);
        private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
        private final PositionIncrementAttribute positionIncrementAttr = this.addAttribute(PositionIncrementAttribute.class);
        private final UidField field;
        private boolean added = false;

        public UidPayloadTokenStream(UidField field2) {
            this.field = field2;
        }

        @Override
        public void reset() throws IOException {
            this.added = false;
        }

        @Override
        public final boolean incrementToken() throws IOException {
            if (this.added) {
                return false;
            }
            this.positionIncrementAttr.setPositionIncrement(1);
            this.termAtt.setLength(0);
            this.termAtt.append(this.field.uid);
            this.payloadAttribute.setPayload(new BytesRef(Numbers.longToBytes(this.field.version())));
            this.added = true;
            return true;
        }
    }

    public static class DocIdAndVersion {
        public final int docId;
        public final long version;
        public final AtomicReaderContext reader;

        public DocIdAndVersion(int docId, long version, AtomicReaderContext reader) {
            this.docId = docId;
            this.version = version;
            this.reader = reader;
        }
    }
}

