/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class RandomScoreFunction
extends ScoreFunction {
    private final PRNG prng;
    private int docBase;

    public RandomScoreFunction(long seed) {
        super(CombineFunction.MULT);
        this.prng = new PRNG(seed);
    }

    @Override
    public void setNextReader(AtomicReaderContext context) {
        this.docBase = context.docBase;
    }

    @Override
    public double score(int docId, float subQueryScore) {
        return this.prng.random(this.docBase + docId);
    }

    @Override
    public Explanation explainScore(int docId, Explanation subQueryExpl) {
        Explanation exp = new Explanation();
        exp.setDescription("random score function (seed: " + this.prng.originalSeed + ")");
        exp.addDetail(subQueryExpl);
        return exp;
    }

    static class PRNG {
        private static final long multiplier = 25214903917L;
        private static final long addend = 11L;
        private static final long mask = 0xFFFFFFFFFFFFL;
        final long originalSeed;
        long seed;

        PRNG(long seed) {
            this.originalSeed = seed;
            this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        }

        public float random(int doc) {
            if (doc == 0) {
                doc = 212855723;
            }
            long rand = doc;
            rand |= rand << 32;
            rand ^= rand;
            return this.nextFloat(rand);
        }

        public float nextFloat(long rand) {
            this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            double result2 = (double)(rand ^= this.seed) / 1.8014398509481984E16;
            return (float)result2;
        }
    }
}

