/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.Queries;

public class XFilteredQuery
extends Query {
    private final Filter rawFilter;
    private final FilteredQuery delegate;
    private final FilteredQuery.FilterStrategy strategy;
    public static final FilteredQuery.FilterStrategy ALWAYS_RANDOM_ACCESS_FILTER_STRATEGY = new CustomRandomAccessFilterStrategy(0);
    public static final CustomRandomAccessFilterStrategy CUSTOM_FILTER_STRATEGY = new CustomRandomAccessFilterStrategy();

    public XFilteredQuery(Query query, Filter filter2) {
        this(query, filter2, FilteredQuery.RANDOM_ACCESS_FILTER_STRATEGY);
    }

    public XFilteredQuery(Query query, Filter filter2, FilteredQuery.FilterStrategy strategy) {
        this.delegate = new FilteredQuery(query, new ApplyAcceptedDocsFilter(filter2), strategy);
        this.rawFilter = filter2;
        this.strategy = strategy;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return this.delegate.createWeight(searcher);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query query = this.delegate.getQuery();
        Query queryRewritten = query.rewrite(reader);
        if (queryRewritten instanceof MatchAllDocsQuery || Queries.isConstantMatchAllQuery(queryRewritten)) {
            ConstantScoreQuery rewritten = new ConstantScoreQuery(this.delegate.getFilter());
            rewritten.setBoost(this.delegate.getBoost() * queryRewritten.getBoost());
            return rewritten;
        }
        if (queryRewritten != query) {
            XFilteredQuery rewritten = new XFilteredQuery(queryRewritten, this.rawFilter, this.strategy);
            ((Query)rewritten).setBoost(this.delegate.getBoost());
            return rewritten;
        }
        return this;
    }

    @Override
    public void setBoost(float b) {
        this.delegate.setBoost(b);
    }

    @Override
    public float getBoost() {
        return this.delegate.getBoost();
    }

    public final Query getQuery() {
        return this.delegate.getQuery();
    }

    public final Filter getFilter() {
        if (this.rawFilter instanceof ApplyAcceptedDocsFilter) {
            return ((ApplyAcceptedDocsFilter)this.rawFilter).filter();
        }
        return this.rawFilter;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.delegate.extractTerms(terms);
    }

    @Override
    public String toString(String s) {
        return this.delegate.toString(s);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof XFilteredQuery)) {
            return false;
        }
        return this.delegate.equals(((XFilteredQuery)o).delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static class CustomRandomAccessFilterStrategy
    extends FilteredQuery.RandomAccessFilterStrategy {
        private final int threshold;

        public CustomRandomAccessFilterStrategy() {
            this.threshold = -1;
        }

        public CustomRandomAccessFilterStrategy(int threshold) {
            this.threshold = threshold;
        }

        @Override
        public Scorer filteredScorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Weight weight, DocIdSet docIdSet) throws IOException {
            if (this.threshold == 0) {
                Bits filterAcceptDocs = docIdSet.bits();
                if (filterAcceptDocs != null) {
                    return weight.scorer(context, scoreDocsInOrder, topScorer, filterAcceptDocs);
                }
                return FilteredQuery.LEAP_FROG_QUERY_FIRST_STRATEGY.filteredScorer(context, scoreDocsInOrder, topScorer, weight, docIdSet);
            }
            if (this.threshold == -1 && !DocIdSets.isFastIterator(docIdSet)) {
                return FilteredQuery.QUERY_FIRST_FILTER_STRATEGY.filteredScorer(context, scoreDocsInOrder, topScorer, weight, docIdSet);
            }
            return super.filteredScorer(context, scoreDocsInOrder, topScorer, weight, docIdSet);
        }

        @Override
        protected boolean useRandomAccess(Bits bits2, int firstFilterDoc) {
            if (this.threshold == -1) {
                return firstFilterDoc < 100;
            }
            return firstFilterDoc < this.threshold;
        }
    }
}

