/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.docset.AllDocIdSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.docset.NotDocIdSet;

public class NotFilter
extends Filter {
    private final Filter filter;

    public NotFilter(Filter filter2) {
        this.filter = filter2;
    }

    public Filter filter() {
        return this.filter;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        DocIdSet set = this.filter.getDocIdSet(context, acceptDocs);
        if (DocIdSets.isEmpty(set)) {
            return new AllDocIdSet(context.reader().maxDoc());
        }
        return new NotDocIdSet(set, context.reader().maxDoc());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotFilter notFilter = (NotFilter)o;
        return !(this.filter == null ? notFilter.filter != null : !this.filter.equals(notFilter.filter));
    }

    public String toString() {
        return "NotFilter(" + this.filter + ")";
    }

    public int hashCode() {
        return this.filter != null ? this.filter.hashCode() : 0;
    }
}

