/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public final class MatchNoDocsQuery
extends Query {
    public static MatchNoDocsQuery INSTANCE = new MatchNoDocsQuery();
    private static final int HASH_CODE = 12345;

    @Override
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return new MatchNoDocsWeight();
    }

    @Override
    public void extractTerms(Set<Term> terms) {
    }

    @Override
    public String toString(String field2) {
        return "MatchNoDocsQuery";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MatchAllDocsQuery;
    }

    @Override
    public int hashCode() {
        return 12345;
    }

    private class MatchNoDocsWeight
    extends Weight {
        private MatchNoDocsWeight() {
        }

        public String toString() {
            return "weight(" + MatchNoDocsQuery.this + ")";
        }

        @Override
        public Query getQuery() {
            return MatchNoDocsQuery.this;
        }

        @Override
        public float getValueForNormalization() throws IOException {
            return 0.0f;
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
        }

        @Override
        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            return null;
        }

        @Override
        public Explanation explain(AtomicReaderContext context, int doc) {
            return new ComplexExplanation(false, 0.0f, "MatchNoDocs matches nothing");
        }
    }
}

