/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;

public class OrDocIdSet
extends DocIdSet {
    private final DocIdSet[] sets;

    public OrDocIdSet(DocIdSet[] sets) {
        this.sets = sets;
    }

    @Override
    public boolean isCacheable() {
        for (DocIdSet set : this.sets) {
            if (set.isCacheable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Bits bits() throws IOException {
        Bits[] bits2 = new Bits[this.sets.length];
        for (int i = 0; i < this.sets.length; ++i) {
            bits2[i] = this.sets[i].bits();
            if (bits2[i] != null) continue;
            return null;
        }
        return new OrBits(bits2);
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        return new IteratorBasedIterator(this.sets);
    }

    static class IteratorBasedIterator
    extends DocIdSetIterator {
        private int _curDoc = -1;
        private final Item[] _heap;
        private int _size;
        private final long cost;

        IteratorBasedIterator(DocIdSet[] sets) throws IOException {
            this._heap = new Item[sets.length];
            this._size = 0;
            long cost = 0L;
            for (DocIdSet set : sets) {
                DocIdSetIterator iterator2 = set.iterator();
                if (iterator2 == null) continue;
                this._heap[this._size++] = new Item(iterator2);
                cost += iterator2.cost();
            }
            this.cost = cost;
            if (this._size == 0) {
                this._curDoc = Integer.MAX_VALUE;
            }
        }

        @Override
        public final int docID() {
            return this._curDoc;
        }

        @Override
        public final int nextDoc() throws IOException {
            int topDoc;
            if (this._curDoc == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            Item top = this._heap[0];
            do {
                DocIdSetIterator topIter;
                int docid;
                if ((docid = (topIter = top.iter).nextDoc()) != Integer.MAX_VALUE) {
                    top.doc = docid;
                    this.heapAdjust();
                } else {
                    this.heapRemoveRoot();
                    if (this._size == 0) {
                        this._curDoc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                }
                top = this._heap[0];
            } while ((topDoc = top.doc) <= this._curDoc);
            this._curDoc = topDoc;
            return this._curDoc;
        }

        @Override
        public final int advance(int target) throws IOException {
            int topDoc;
            if (this._curDoc == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (target <= this._curDoc) {
                target = this._curDoc + 1;
            }
            Item top = this._heap[0];
            do {
                DocIdSetIterator topIter;
                int docid;
                if ((docid = (topIter = top.iter).advance(target)) != Integer.MAX_VALUE) {
                    top.doc = docid;
                    this.heapAdjust();
                } else {
                    this.heapRemoveRoot();
                    if (this._size == 0) {
                        this._curDoc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                }
                top = this._heap[0];
            } while ((topDoc = top.doc) < target);
            this._curDoc = topDoc;
            return this._curDoc;
        }

        private final void heapAdjust() {
            int lchild;
            Item[] heap = this._heap;
            Item top = heap[0];
            int doc = top.doc;
            int size2 = this._size;
            int i = 0;
            while ((lchild = (i << 1) + 1) < size2) {
                Item left = heap[lchild];
                int ldoc = left.doc;
                int rchild = lchild + 1;
                if (rchild < size2) {
                    Item right = heap[rchild];
                    int rdoc = right.doc;
                    if (rdoc <= ldoc) {
                        if (doc <= rdoc) break;
                        heap[i] = right;
                        i = rchild;
                        continue;
                    }
                }
                if (doc <= ldoc) break;
                heap[i] = left;
                i = lchild;
            }
            heap[i] = top;
        }

        private void heapRemoveRoot() {
            --this._size;
            if (this._size > 0) {
                Item tmp = this._heap[0];
                this._heap[0] = this._heap[this._size];
                this._heap[this._size] = tmp;
                this.heapAdjust();
            }
        }

        @Override
        public long cost() {
            return this.cost;
        }

        final class Item {
            public final DocIdSetIterator iter;
            public int doc;

            public Item(DocIdSetIterator iter2) {
                this.iter = iter2;
                this.doc = -1;
            }
        }
    }

    static class OrBits
    implements Bits {
        private final Bits[] bits;

        OrBits(Bits[] bits2) {
            this.bits = bits2;
        }

        @Override
        public boolean get(int index) {
            for (Bits bit : this.bits) {
                if (!bit.get(index)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int length() {
            return this.bits[0].length();
        }
    }
}

