/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.Nullable;

public abstract class MatchDocIdSet
extends DocIdSet
implements Bits {
    private final int maxDoc;
    private final Bits acceptDocs;

    protected MatchDocIdSet(int maxDoc, @Nullable Bits acceptDocs) {
        this.maxDoc = maxDoc;
        this.acceptDocs = acceptDocs;
    }

    protected abstract boolean matchDoc(int var1);

    @Override
    public DocIdSetIterator iterator() throws IOException {
        if (this.acceptDocs == null) {
            return new NoAcceptDocsIterator(this.maxDoc);
        }
        if (this.acceptDocs instanceof FixedBitSet) {
            return new FixedBitSetIterator(((DocIdSet)((Object)this.acceptDocs)).iterator());
        }
        return new BothIterator(this.maxDoc, this.acceptDocs);
    }

    @Override
    public Bits bits() throws IOException {
        return this;
    }

    @Override
    public boolean get(int index) {
        return this.matchDoc(index);
    }

    @Override
    public int length() {
        return this.maxDoc;
    }

    class BothIterator
    extends DocIdSetIterator {
        private final int maxDoc;
        private final Bits acceptDocs;
        private int doc = -1;

        BothIterator(int maxDoc, Bits acceptDocs) {
            this.maxDoc = maxDoc;
            this.acceptDocs = acceptDocs;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() {
            do {
                ++this.doc;
                if (this.doc < this.maxDoc) continue;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            } while (!MatchDocIdSet.this.matchDoc(this.doc) || !this.acceptDocs.get(this.doc));
            return this.doc;
        }

        @Override
        public int advance(int target) {
            this.doc = target;
            while (this.doc < this.maxDoc) {
                if (MatchDocIdSet.this.matchDoc(this.doc) && this.acceptDocs.get(this.doc)) {
                    return this.doc;
                }
                ++this.doc;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }
    }

    class FixedBitSetIterator
    extends FilteredDocIdSetIterator {
        FixedBitSetIterator(DocIdSetIterator innerIter) {
            super(innerIter);
        }

        @Override
        protected boolean match(int doc) {
            return MatchDocIdSet.this.matchDoc(doc);
        }
    }

    class NoAcceptDocsIterator
    extends DocIdSetIterator {
        private final int maxDoc;
        private int doc = -1;

        NoAcceptDocsIterator(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() {
            do {
                ++this.doc;
                if (this.doc < this.maxDoc) continue;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            } while (!MatchDocIdSet.this.matchDoc(this.doc));
            return this.doc;
        }

        @Override
        public int advance(int target) {
            this.doc = target;
            while (this.doc < this.maxDoc) {
                if (MatchDocIdSet.this.matchDoc(this.doc)) {
                    return this.doc;
                }
                ++this.doc;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }
    }
}

