/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.docset.MatchDocIdSetIterator;

public class BitsDocIdSetIterator
extends MatchDocIdSetIterator {
    private final Bits bits;

    public BitsDocIdSetIterator(Bits bits2) {
        super(bits2.length());
        this.bits = bits2;
    }

    public BitsDocIdSetIterator(int maxDoc, Bits bits2) {
        super(maxDoc);
        this.bits = bits2;
    }

    @Override
    protected boolean matchDoc(int doc) {
        return this.bits.get(doc);
    }

    @Override
    public long cost() {
        return this.bits.length();
    }

    public static class FilteredIterator
    extends FilteredDocIdSetIterator {
        private final Bits bits;

        FilteredIterator(DocIdSetIterator innerIter, Bits bits2) {
            super(innerIter);
            this.bits = bits2;
        }

        @Override
        protected boolean match(int doc) {
            return this.bits.get(doc);
        }
    }
}

