/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.docset.BitsDocIdSetIterator;
import org.elasticsearch.common.lucene.docset.DocIdSets;

public class AndDocIdSet
extends DocIdSet {
    private final DocIdSet[] sets;

    public AndDocIdSet(DocIdSet[] sets) {
        this.sets = sets;
    }

    @Override
    public boolean isCacheable() {
        for (DocIdSet set : this.sets) {
            if (set.isCacheable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Bits bits() throws IOException {
        Bits[] bits2 = new Bits[this.sets.length];
        for (int i = 0; i < this.sets.length; ++i) {
            bits2[i] = this.sets[i].bits();
            if (bits2[i] != null) continue;
            return null;
        }
        return new AndBits(bits2);
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        ArrayList<DocIdSet> iterators = new ArrayList<DocIdSet>(this.sets.length);
        ArrayList<Bits> bits2 = new ArrayList<Bits>(this.sets.length);
        for (DocIdSet set : this.sets) {
            if (DocIdSets.isFastIterator(set)) {
                iterators.add(set);
                continue;
            }
            Bits bit = set.bits();
            if (bit != null) {
                bits2.add(bit);
                continue;
            }
            iterators.add(set);
        }
        if (bits2.isEmpty()) {
            return new IteratorBasedIterator(iterators.toArray(new DocIdSet[iterators.size()]));
        }
        if (iterators.isEmpty()) {
            return new BitsDocIdSetIterator(new AndBits(bits2.toArray(new Bits[bits2.size()])));
        }
        return new BitsDocIdSetIterator.FilteredIterator(new IteratorBasedIterator(iterators.toArray(new DocIdSet[iterators.size()])), new AndBits(bits2.toArray(new Bits[bits2.size()])));
    }

    static class IteratorBasedIterator
    extends DocIdSetIterator {
        int lastReturn = -1;
        private DocIdSetIterator[] iterators = null;
        private final long cost;

        IteratorBasedIterator(DocIdSet[] sets) throws IOException {
            this.iterators = new DocIdSetIterator[sets.length];
            int j = 0;
            long cost = Integer.MAX_VALUE;
            for (DocIdSet set : sets) {
                if (set == null) {
                    this.lastReturn = Integer.MAX_VALUE;
                    break;
                }
                DocIdSetIterator dcit = set.iterator();
                if (dcit == null) {
                    this.lastReturn = Integer.MAX_VALUE;
                    break;
                }
                this.iterators[j++] = dcit;
                cost = Math.min(cost, dcit.cost());
            }
            this.cost = cost;
            if (this.lastReturn != Integer.MAX_VALUE) {
                this.lastReturn = this.iterators.length > 0 ? -1 : Integer.MAX_VALUE;
            }
        }

        @Override
        public final int docID() {
            return this.lastReturn;
        }

        @Override
        public final int nextDoc() throws IOException {
            if (this.lastReturn == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            DocIdSetIterator dcit = this.iterators[0];
            int target = dcit.nextDoc();
            int size2 = this.iterators.length;
            int skip = 0;
            int i = 1;
            while (i < size2) {
                int docid;
                if (i != skip && (docid = (dcit = this.iterators[i]).advance(target)) > target) {
                    target = docid;
                    if (i != 0) {
                        skip = i;
                        i = 0;
                        continue;
                    }
                    skip = 0;
                }
                ++i;
            }
            this.lastReturn = target;
            return this.lastReturn;
        }

        @Override
        public final int advance(int target) throws IOException {
            if (this.lastReturn == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            DocIdSetIterator dcit = this.iterators[0];
            target = dcit.advance(target);
            int size2 = this.iterators.length;
            int skip = 0;
            int i = 1;
            while (i < size2) {
                int docid;
                if (i != skip && (docid = (dcit = this.iterators[i]).advance(target)) > target) {
                    target = docid;
                    if (i != 0) {
                        skip = i;
                        i = 0;
                        continue;
                    }
                    skip = 0;
                }
                ++i;
            }
            this.lastReturn = target;
            return this.lastReturn;
        }

        @Override
        public long cost() {
            return this.cost;
        }
    }

    static class AndBits
    implements Bits {
        private final Bits[] bits;

        AndBits(Bits[] bits2) {
            this.bits = bits2;
        }

        @Override
        public boolean get(int index) {
            for (Bits bit : this.bits) {
                if (bit.get(index)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int length() {
            return this.bits[0].length();
        }
    }
}

