/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.all;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.io.FastCharArrayWriter;
import org.elasticsearch.common.io.FastStringReader;

public class AllEntries
extends Reader {
    private final List<Entry> entries = Lists.newArrayList();
    private Entry current;
    private Iterator<Entry> it;
    private boolean itsSeparatorTime = false;
    private boolean customBoost = false;

    public void addText(String name, String text2, float boost) {
        int lastStartOffset;
        if (boost != 1.0f) {
            this.customBoost = true;
        }
        if (this.entries.isEmpty()) {
            lastStartOffset = -1;
        } else {
            Entry last2 = this.entries.get(this.entries.size() - 1);
            lastStartOffset = last2.startOffset() + last2.reader().length();
        }
        int startOffset = lastStartOffset + 1;
        Entry entry2 = new Entry(name, new FastStringReader(text2), startOffset, boost);
        this.entries.add(entry2);
    }

    public boolean customBoost() {
        return this.customBoost;
    }

    public void clear() {
        this.entries.clear();
        this.current = null;
        this.it = null;
        this.itsSeparatorTime = false;
    }

    @Override
    public void reset() {
        try {
            for (Entry entry2 : this.entries) {
                entry2.reader().reset();
            }
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalStateException("should not happen");
        }
        this.it = this.entries.iterator();
        if (this.it.hasNext()) {
            this.current = this.it.next();
            this.itsSeparatorTime = true;
        }
    }

    public String buildText() {
        this.reset();
        FastCharArrayWriter writer = new FastCharArrayWriter();
        for (Entry entry2 : this.entries) {
            writer.append(entry2.reader());
            writer.append(' ');
        }
        this.reset();
        return writer.toString();
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public Set<String> fields() {
        HashSet<String> fields = Sets.newHashSet();
        for (Entry entry2 : this.entries) {
            fields.add(entry2.name());
        }
        return fields;
    }

    public float boost(int startOffset) {
        int lo = 0;
        int hi = this.entries.size() - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midOffset = this.entries.get(mid).startOffset();
            if (startOffset < midOffset) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        int index = Math.max(0, hi);
        assert (this.entries.get(index).startOffset() <= startOffset);
        assert (index == this.entries.size() - 1 || this.entries.get(index + 1).startOffset() > startOffset);
        return this.entries.get(index).boost();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.current == null) {
            return -1;
        }
        if (this.customBoost) {
            int result2 = this.current.reader().read(cbuf, off, len);
            if (result2 == -1) {
                if (this.itsSeparatorTime) {
                    this.itsSeparatorTime = false;
                    cbuf[off] = 32;
                    return 1;
                }
                this.itsSeparatorTime = true;
                this.current = this.it.hasNext() ? this.it.next() : null;
                return this.read(cbuf, off, len);
            }
            return result2;
        }
        int read2 = 0;
        while (len > 0) {
            int result3 = this.current.reader().read(cbuf, off, len);
            if (result3 == -1) {
                if (!this.it.hasNext()) {
                    this.current = null;
                    if (read2 == 0) {
                        return -1;
                    }
                    return read2;
                }
                this.current = this.it.next();
                cbuf[off++] = 32;
                ++read2;
                --len;
                continue;
            }
            read2 += result3;
            off += result3;
            len -= result3;
        }
        return read2;
    }

    @Override
    public void close() {
        if (this.current != null) {
            this.current = null;
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.current != null && this.current.reader().ready();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Entry entry2 : this.entries) {
            sb.append(entry2.name()).append(',');
        }
        return sb.toString();
    }

    public static class Entry {
        private final String name;
        private final FastStringReader reader;
        private final int startOffset;
        private final float boost;

        public Entry(String name, FastStringReader reader, int startOffset, float boost) {
            this.name = name;
            this.reader = reader;
            this.startOffset = startOffset;
            this.boost = boost;
        }

        public int startOffset() {
            return this.startOffset;
        }

        public String name() {
            return this.name;
        }

        public float boost() {
            return this.boost;
        }

        public FastStringReader reader() {
            return this.reader;
        }
    }
}

