/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class LoggerInfoStream
extends PrintStream {
    public static final String SUFFIX = ".lucene";
    private final ESLogger logger;

    public static LoggerInfoStream getInfoStream(ESLogger logger) {
        try {
            return new LoggerInfoStream(Loggers.getLogger(logger, SUFFIX));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static LoggerInfoStream getInfoStream(String name) {
        try {
            return new LoggerInfoStream(Loggers.getLogger(name + SUFFIX));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public LoggerInfoStream(ESLogger logger) throws UnsupportedEncodingException {
        super((OutputStream)null, false, Charsets.UTF_8.name());
        this.logger = logger;
    }

    @Override
    public void println(String x2) {
        this.logger.trace(x2, new Object[0]);
    }
}

