/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.joda.time.Chronology;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.ReadablePartial;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;
import org.elasticsearch.common.joda.time.format.DateTimeFormatterBuilder;
import org.elasticsearch.common.joda.time.format.DateTimeParser;
import org.elasticsearch.common.joda.time.format.DateTimeParserBucket;
import org.elasticsearch.common.joda.time.format.DateTimePrinter;

public class DateTimeFormat {
    static final int FULL = 0;
    static final int LONG = 1;
    static final int MEDIUM = 2;
    static final int SHORT = 3;
    static final int NONE = 4;
    static final int DATE = 0;
    static final int TIME = 1;
    static final int DATETIME = 2;
    private static final int PATTERN_CACHE_SIZE = 500;
    private static final Map<String, DateTimeFormatter> PATTERN_CACHE = new LinkedHashMap<String, DateTimeFormatter>(7){
        private static final long serialVersionUID = 23L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, DateTimeFormatter> entry2) {
            return this.size() > 500;
        }
    };
    private static final DateTimeFormatter[] STYLE_CACHE = new DateTimeFormatter[25];

    public static DateTimeFormatter forPattern(String string2) {
        return DateTimeFormat.createFormatterForPattern(string2);
    }

    public static DateTimeFormatter forStyle(String string2) {
        return DateTimeFormat.createFormatterForStyle(string2);
    }

    public static String patternForStyle(String string2, Locale locale) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.createFormatterForStyle(string2);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ((StyleFormatter)dateTimeFormatter.getPrinter()).getPattern(locale);
    }

    public static DateTimeFormatter shortDate() {
        return DateTimeFormat.createFormatterForStyleIndex(3, 4);
    }

    public static DateTimeFormatter shortTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 3);
    }

    public static DateTimeFormatter shortDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(3, 3);
    }

    public static DateTimeFormatter mediumDate() {
        return DateTimeFormat.createFormatterForStyleIndex(2, 4);
    }

    public static DateTimeFormatter mediumTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 2);
    }

    public static DateTimeFormatter mediumDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(2, 2);
    }

    public static DateTimeFormatter longDate() {
        return DateTimeFormat.createFormatterForStyleIndex(1, 4);
    }

    public static DateTimeFormatter longTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 1);
    }

    public static DateTimeFormatter longDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(1, 1);
    }

    public static DateTimeFormatter fullDate() {
        return DateTimeFormat.createFormatterForStyleIndex(0, 4);
    }

    public static DateTimeFormatter fullTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 0);
    }

    public static DateTimeFormatter fullDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(0, 0);
    }

    static void appendPatternTo(DateTimeFormatterBuilder dateTimeFormatterBuilder, String string2) {
        DateTimeFormat.parsePatternTo(dateTimeFormatterBuilder, string2);
    }

    protected DateTimeFormat() {
    }

    private static void parsePatternTo(DateTimeFormatterBuilder dateTimeFormatterBuilder, String string2) {
        int n = string2.length();
        int[] nArray = new int[1];
        block30: for (int i = 0; i < n; ++i) {
            nArray[0] = i;
            String string3 = DateTimeFormat.parseToken(string2, nArray);
            i = nArray[0];
            int n2 = string3.length();
            if (n2 == 0) break;
            char c = string3.charAt(0);
            switch (c) {
                case 'G': {
                    dateTimeFormatterBuilder.appendEraText();
                    continue block30;
                }
                case 'C': {
                    dateTimeFormatterBuilder.appendCenturyOfEra(n2, n2);
                    continue block30;
                }
                case 'Y': 
                case 'x': 
                case 'y': {
                    if (n2 == 2) {
                        boolean bl = true;
                        if (i + 1 < n) {
                            nArray[0] = nArray[0] + 1;
                            if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(string2, nArray))) {
                                bl = false;
                            }
                            nArray[0] = nArray[0] - 1;
                        }
                        switch (c) {
                            case 'x': {
                                dateTimeFormatterBuilder.appendTwoDigitWeekyear(new DateTime().getWeekyear() - 30, bl);
                                continue block30;
                            }
                        }
                        dateTimeFormatterBuilder.appendTwoDigitYear(new DateTime().getYear() - 30, bl);
                        continue block30;
                    }
                    int n3 = 9;
                    if (i + 1 < n) {
                        nArray[0] = nArray[0] + 1;
                        if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(string2, nArray))) {
                            n3 = n2;
                        }
                        nArray[0] = nArray[0] - 1;
                    }
                    switch (c) {
                        case 'x': {
                            dateTimeFormatterBuilder.appendWeekyear(n2, n3);
                            break;
                        }
                        case 'y': {
                            dateTimeFormatterBuilder.appendYear(n2, n3);
                            break;
                        }
                        case 'Y': {
                            dateTimeFormatterBuilder.appendYearOfEra(n2, n3);
                        }
                    }
                    continue block30;
                }
                case 'M': {
                    if (n2 >= 3) {
                        if (n2 >= 4) {
                            dateTimeFormatterBuilder.appendMonthOfYearText();
                            continue block30;
                        }
                        dateTimeFormatterBuilder.appendMonthOfYearShortText();
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendMonthOfYear(n2);
                    continue block30;
                }
                case 'd': {
                    dateTimeFormatterBuilder.appendDayOfMonth(n2);
                    continue block30;
                }
                case 'a': {
                    dateTimeFormatterBuilder.appendHalfdayOfDayText();
                    continue block30;
                }
                case 'h': {
                    dateTimeFormatterBuilder.appendClockhourOfHalfday(n2);
                    continue block30;
                }
                case 'H': {
                    dateTimeFormatterBuilder.appendHourOfDay(n2);
                    continue block30;
                }
                case 'k': {
                    dateTimeFormatterBuilder.appendClockhourOfDay(n2);
                    continue block30;
                }
                case 'K': {
                    dateTimeFormatterBuilder.appendHourOfHalfday(n2);
                    continue block30;
                }
                case 'm': {
                    dateTimeFormatterBuilder.appendMinuteOfHour(n2);
                    continue block30;
                }
                case 's': {
                    dateTimeFormatterBuilder.appendSecondOfMinute(n2);
                    continue block30;
                }
                case 'S': {
                    dateTimeFormatterBuilder.appendFractionOfSecond(n2, n2);
                    continue block30;
                }
                case 'e': {
                    dateTimeFormatterBuilder.appendDayOfWeek(n2);
                    continue block30;
                }
                case 'E': {
                    if (n2 >= 4) {
                        dateTimeFormatterBuilder.appendDayOfWeekText();
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendDayOfWeekShortText();
                    continue block30;
                }
                case 'D': {
                    dateTimeFormatterBuilder.appendDayOfYear(n2);
                    continue block30;
                }
                case 'w': {
                    dateTimeFormatterBuilder.appendWeekOfWeekyear(n2);
                    continue block30;
                }
                case 'z': {
                    if (n2 >= 4) {
                        dateTimeFormatterBuilder.appendTimeZoneName();
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendTimeZoneShortName(null);
                    continue block30;
                }
                case 'Z': {
                    if (n2 == 1) {
                        dateTimeFormatterBuilder.appendTimeZoneOffset(null, "Z", false, 2, 2);
                        continue block30;
                    }
                    if (n2 == 2) {
                        dateTimeFormatterBuilder.appendTimeZoneOffset(null, "Z", true, 2, 2);
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendTimeZoneId();
                    continue block30;
                }
                case '\'': {
                    String string4 = string3.substring(1);
                    if (string4.length() == 1) {
                        dateTimeFormatterBuilder.appendLiteral(string4.charAt(0));
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendLiteral(new String(string4));
                    continue block30;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string3);
                }
            }
        }
    }

    private static String parseToken(String string2, int[] nArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string2.length();
        char c = string2.charAt(n);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            char c2;
            stringBuilder.append(c);
            while (n + 1 < n2 && (c2 = string2.charAt(n + 1)) == c) {
                stringBuilder.append(c);
                ++n;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl = false;
            for (n = nArray[0]; n < n2; ++n) {
                c = string2.charAt(n);
                if (c == '\'') {
                    if (n + 1 < n2 && string2.charAt(n + 1) == '\'') {
                        ++n;
                        stringBuilder.append(c);
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (bl || (c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) {
                    stringBuilder.append(c);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n;
        return stringBuilder.toString();
    }

    private static boolean isNumericToken(String string2) {
        int n = string2.length();
        if (n > 0) {
            char c = string2.charAt(0);
            switch (c) {
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'K': 
                case 'S': 
                case 'W': 
                case 'Y': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'k': 
                case 'm': 
                case 's': 
                case 'w': 
                case 'x': 
                case 'y': {
                    return true;
                }
                case 'M': {
                    if (n > 2) break;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateTimeFormatter createFormatterForPattern(String string2) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid pattern specification");
        }
        DateTimeFormatter dateTimeFormatter = null;
        Map<String, DateTimeFormatter> map2 = PATTERN_CACHE;
        synchronized (map2) {
            dateTimeFormatter = PATTERN_CACHE.get(string2);
            if (dateTimeFormatter == null) {
                DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
                DateTimeFormat.parsePatternTo(dateTimeFormatterBuilder, string2);
                dateTimeFormatter = dateTimeFormatterBuilder.toFormatter();
                PATTERN_CACHE.put(string2, dateTimeFormatter);
            }
        }
        return dateTimeFormatter;
    }

    private static DateTimeFormatter createFormatterForStyle(String string2) {
        if (string2 == null || string2.length() != 2) {
            throw new IllegalArgumentException("Invalid style specification: " + string2);
        }
        int n = DateTimeFormat.selectStyle(string2.charAt(0));
        int n2 = DateTimeFormat.selectStyle(string2.charAt(1));
        if (n == 4 && n2 == 4) {
            throw new IllegalArgumentException("Style '--' is invalid");
        }
        return DateTimeFormat.createFormatterForStyleIndex(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateTimeFormatter createFormatterForStyleIndex(int n, int n2) {
        int n3 = (n << 2) + n + n2;
        if (n3 >= STYLE_CACHE.length) {
            return DateTimeFormat.createDateTimeFormatter(n, n2);
        }
        DateTimeFormatter dateTimeFormatter = null;
        DateTimeFormatter[] dateTimeFormatterArray = STYLE_CACHE;
        synchronized (STYLE_CACHE) {
            dateTimeFormatter = STYLE_CACHE[n3];
            if (dateTimeFormatter == null) {
                DateTimeFormat.STYLE_CACHE[n3] = dateTimeFormatter = DateTimeFormat.createDateTimeFormatter(n, n2);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return dateTimeFormatter;
        }
    }

    private static DateTimeFormatter createDateTimeFormatter(int n, int n2) {
        int n3 = 2;
        if (n == 4) {
            n3 = 1;
        } else if (n2 == 4) {
            n3 = 0;
        }
        StyleFormatter styleFormatter = new StyleFormatter(n, n2, n3);
        return new DateTimeFormatter(styleFormatter, styleFormatter);
    }

    private static int selectStyle(char c) {
        switch (c) {
            case 'S': {
                return 3;
            }
            case 'M': {
                return 2;
            }
            case 'L': {
                return 1;
            }
            case 'F': {
                return 0;
            }
            case '-': {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid style character: " + c);
    }

    static class StyleFormatter
    implements DateTimePrinter,
    DateTimeParser {
        private static final Map<String, DateTimeFormatter> cCache = new HashMap<String, DateTimeFormatter>();
        private final int iDateStyle;
        private final int iTimeStyle;
        private final int iType;

        StyleFormatter(int n, int n2, int n3) {
            this.iDateStyle = n;
            this.iTimeStyle = n2;
            this.iType = n3;
        }

        public int estimatePrintedLength() {
            return 40;
        }

        public void printTo(StringBuffer stringBuffer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) {
            DateTimePrinter dateTimePrinter = this.getFormatter(locale).getPrinter();
            dateTimePrinter.printTo(stringBuffer, l, chronology, n, dateTimeZone, locale);
        }

        public void printTo(Writer writer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            DateTimePrinter dateTimePrinter = this.getFormatter(locale).getPrinter();
            dateTimePrinter.printTo(writer, l, chronology, n, dateTimeZone, locale);
        }

        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            DateTimePrinter dateTimePrinter = this.getFormatter(locale).getPrinter();
            dateTimePrinter.printTo(stringBuffer, readablePartial, locale);
        }

        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
            DateTimePrinter dateTimePrinter = this.getFormatter(locale).getPrinter();
            dateTimePrinter.printTo(writer, readablePartial, locale);
        }

        public int estimateParsedLength() {
            return 40;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n) {
            DateTimeParser dateTimeParser = this.getFormatter(dateTimeParserBucket.getLocale()).getParser();
            return dateTimeParser.parseInto(dateTimeParserBucket, string2, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DateTimeFormatter getFormatter(Locale locale) {
            locale = locale == null ? Locale.getDefault() : locale;
            String string2 = Integer.toString(this.iType + (this.iDateStyle << 4) + (this.iTimeStyle << 8)) + locale.toString();
            DateTimeFormatter dateTimeFormatter = null;
            Map<String, DateTimeFormatter> map2 = cCache;
            synchronized (map2) {
                dateTimeFormatter = cCache.get(string2);
                if (dateTimeFormatter == null) {
                    String string3 = this.getPattern(locale);
                    dateTimeFormatter = DateTimeFormat.forPattern(string3);
                    cCache.put(string2, dateTimeFormatter);
                }
            }
            return dateTimeFormatter;
        }

        String getPattern(Locale locale) {
            DateFormat dateFormat = null;
            switch (this.iType) {
                case 0: {
                    dateFormat = DateFormat.getDateInstance(this.iDateStyle, locale);
                    break;
                }
                case 1: {
                    dateFormat = DateFormat.getTimeInstance(this.iTimeStyle, locale);
                    break;
                }
                case 2: {
                    dateFormat = DateFormat.getDateTimeInstance(this.iDateStyle, this.iTimeStyle, locale);
                }
            }
            if (!(dateFormat instanceof SimpleDateFormat)) {
                throw new IllegalArgumentException("No datetime pattern for locale: " + locale);
            }
            return ((SimpleDateFormat)dateFormat).toPattern();
        }
    }
}

