/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda;

import java.util.Locale;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.time.Chronology;
import org.elasticsearch.common.joda.time.DateTimeField;
import org.elasticsearch.common.joda.time.DateTimeFieldType;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.DurationField;
import org.elasticsearch.common.joda.time.DurationFieldType;
import org.elasticsearch.common.joda.time.field.DividedDateTimeField;
import org.elasticsearch.common.joda.time.field.OffsetDateTimeField;
import org.elasticsearch.common.joda.time.field.ScaledDurationField;
import org.elasticsearch.common.joda.time.format.DateTimeFormat;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;
import org.elasticsearch.common.joda.time.format.DateTimeFormatterBuilder;
import org.elasticsearch.common.joda.time.format.DateTimeParser;
import org.elasticsearch.common.joda.time.format.ISODateTimeFormat;

public class Joda {
    public static final DurationFieldType Quarters = new DurationFieldType("quarters"){
        private static final long serialVersionUID = -8167713675442491871L;

        @Override
        public DurationField getField(Chronology chronology) {
            return new ScaledDurationField(chronology.months(), Quarters, 3);
        }
    };
    public static final DateTimeFieldType QuarterOfYear = new DateTimeFieldType("quarterOfYear"){
        private static final long serialVersionUID = -5677872459807379123L;

        @Override
        public DurationFieldType getDurationType() {
            return Quarters;
        }

        @Override
        public DurationFieldType getRangeDurationType() {
            return DurationFieldType.years();
        }

        @Override
        public DateTimeField getField(Chronology chronology) {
            return new OffsetDateTimeField((DateTimeField)new DividedDateTimeField(new OffsetDateTimeField(chronology.monthOfYear(), -1), QuarterOfYear, 3), 1);
        }
    };

    public static FormatDateTimeFormatter forPattern(String input2) {
        return Joda.forPattern(input2, null);
    }

    public static FormatDateTimeFormatter forPattern(String input2, Locale locale) {
        DateTimeFormatter formatter;
        if (Strings.hasLength(input2)) {
            input2 = input2.trim();
        }
        if (input2 == null || input2.length() == 0) {
            throw new IllegalArgumentException("No date pattern provided");
        }
        if ("basicDate".equals(input2) || "basic_date".equals(input2)) {
            formatter = ISODateTimeFormat.basicDate();
        } else if ("basicDateTime".equals(input2) || "basic_date_time".equals(input2)) {
            formatter = ISODateTimeFormat.basicDateTime();
        } else if ("basicDateTimeNoMillis".equals(input2) || "basic_date_time_no_millis".equals(input2)) {
            formatter = ISODateTimeFormat.basicDateTimeNoMillis();
        } else if ("basicOrdinalDate".equals(input2) || "basic_ordinal_date".equals(input2)) {
            formatter = ISODateTimeFormat.basicOrdinalDate();
        } else if ("basicOrdinalDateTime".equals(input2) || "basic_ordinal_date_time".equals(input2)) {
            formatter = ISODateTimeFormat.basicOrdinalDateTime();
        } else if ("basicOrdinalDateTimeNoMillis".equals(input2) || "basic_ordinal_date_time_no_millis".equals(input2)) {
            formatter = ISODateTimeFormat.basicOrdinalDateTimeNoMillis();
        } else if ("basicTime".equals(input2) || "basic_time".equals(input2)) {
            formatter = ISODateTimeFormat.basicTime();
        } else if ("basicTimeNoMillis".equals(input2) || "basic_time_no_millis".equals(input2)) {
            formatter = ISODateTimeFormat.basicTimeNoMillis();
        } else if ("basicTTime".equals(input2) || "basic_t_Time".equals(input2)) {
            formatter = ISODateTimeFormat.basicTTime();
        } else if ("basicTTimeNoMillis".equals(input2) || "basic_t_time_no_millis".equals(input2)) {
            formatter = ISODateTimeFormat.basicTTimeNoMillis();
        } else if ("basicWeekDate".equals(input2) || "basic_week_date".equals(input2)) {
            formatter = ISODateTimeFormat.basicWeekDate();
        } else if ("basicWeekDateTime".equals(input2) || "basic_week_date_time".equals(input2)) {
            formatter = ISODateTimeFormat.basicWeekDateTime();
        } else if ("basicWeekDateTimeNoMillis".equals(input2) || "basic_week_date_time_no_millis".equals(input2)) {
            formatter = ISODateTimeFormat.basicWeekDateTimeNoMillis();
        } else if ("date".equals(input2)) {
            formatter = ISODateTimeFormat.date();
        } else if ("dateHour".equals(input2) || "date_hour".equals(input2)) {
            formatter = ISODateTimeFormat.dateHour();
        } else if ("dateHourMinute".equals(input2) || "date_hour_minute".equals(input2)) {
            formatter = ISODateTimeFormat.dateHourMinute();
        } else if ("dateHourMinuteSecond".equals(input2) || "date_hour_minute_second".equals(input2)) {
            formatter = ISODateTimeFormat.dateHourMinuteSecond();
        } else if ("dateHourMinuteSecondFraction".equals(input2) || "date_hour_minute_second_fraction".equals(input2)) {
            formatter = ISODateTimeFormat.dateHourMinuteSecondFraction();
        } else if ("dateHourMinuteSecondMillis".equals(input2) || "date_hour_minute_second_millis".equals(input2)) {
            formatter = ISODateTimeFormat.dateHourMinuteSecondMillis();
        } else {
            if ("dateOptionalTime".equals(input2) || "date_optional_time".equals(input2)) {
                return new FormatDateTimeFormatter(input2, ISODateTimeFormat.dateOptionalTimeParser().withZone(DateTimeZone.UTC), ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC), locale);
            }
            if ("dateTime".equals(input2) || "date_time".equals(input2)) {
                formatter = ISODateTimeFormat.dateTime();
            } else if ("dateTimeNoMillis".equals(input2) || "date_time_no_millis".equals(input2)) {
                formatter = ISODateTimeFormat.dateTimeNoMillis();
            } else if ("hour".equals(input2)) {
                formatter = ISODateTimeFormat.hour();
            } else if ("hourMinute".equals(input2) || "hour_minute".equals(input2)) {
                formatter = ISODateTimeFormat.hourMinute();
            } else if ("hourMinuteSecond".equals(input2) || "hour_minute_second".equals(input2)) {
                formatter = ISODateTimeFormat.hourMinuteSecond();
            } else if ("hourMinuteSecondFraction".equals(input2) || "hour_minute_second_fraction".equals(input2)) {
                formatter = ISODateTimeFormat.hourMinuteSecondFraction();
            } else if ("hourMinuteSecondMillis".equals(input2) || "hour_minute_second_millis".equals(input2)) {
                formatter = ISODateTimeFormat.hourMinuteSecondMillis();
            } else if ("ordinalDate".equals(input2) || "ordinal_date".equals(input2)) {
                formatter = ISODateTimeFormat.ordinalDate();
            } else if ("ordinalDateTime".equals(input2) || "ordinal_date_time".equals(input2)) {
                formatter = ISODateTimeFormat.ordinalDateTime();
            } else if ("ordinalDateTimeNoMillis".equals(input2) || "ordinal_date_time_no_millis".equals(input2)) {
                formatter = ISODateTimeFormat.ordinalDateTimeNoMillis();
            } else if ("time".equals(input2)) {
                formatter = ISODateTimeFormat.time();
            } else if ("tTime".equals(input2) || "t_time".equals(input2)) {
                formatter = ISODateTimeFormat.tTime();
            } else if ("tTimeNoMillis".equals(input2) || "t_time_no_millis".equals(input2)) {
                formatter = ISODateTimeFormat.tTimeNoMillis();
            } else if ("weekDate".equals(input2) || "week_date".equals(input2)) {
                formatter = ISODateTimeFormat.weekDate();
            } else if ("weekDateTime".equals(input2) || "week_date_time".equals(input2)) {
                formatter = ISODateTimeFormat.weekDateTime();
            } else if ("weekyear".equals(input2) || "week_year".equals(input2)) {
                formatter = ISODateTimeFormat.weekyear();
            } else if ("weekyearWeek".equals(input2)) {
                formatter = ISODateTimeFormat.weekyearWeek();
            } else if ("year".equals(input2)) {
                formatter = ISODateTimeFormat.year();
            } else if ("yearMonth".equals(input2) || "year_month".equals(input2)) {
                formatter = ISODateTimeFormat.yearMonth();
            } else if ("yearMonthDay".equals(input2) || "year_month_day".equals(input2)) {
                formatter = ISODateTimeFormat.yearMonthDay();
            } else if (Strings.hasLength(input2) && input2.contains("||")) {
                String[] formats = Strings.delimitedListToStringArray(input2, "||");
                DateTimeParser[] parsers = new DateTimeParser[formats.length];
                if (formats.length == 1) {
                    formatter = Joda.forPattern(input2, locale).parser();
                } else {
                    DateTimeFormatter dateTimeFormatter = null;
                    for (int i = 0; i < formats.length; ++i) {
                        DateTimeFormatter currentFormatter = Joda.forPattern(formats[i], locale).parser();
                        if (dateTimeFormatter == null) {
                            dateTimeFormatter = currentFormatter;
                        }
                        parsers[i] = currentFormatter.getParser();
                    }
                    DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().append(dateTimeFormatter.withZone(DateTimeZone.UTC).getPrinter(), parsers);
                    formatter = builder.toFormatter();
                }
            } else {
                try {
                    formatter = DateTimeFormat.forPattern(input2);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid format: [" + input2 + "]: " + e.getMessage(), e);
                }
            }
        }
        return new FormatDateTimeFormatter(input2, formatter.withZone(DateTimeZone.UTC), locale);
    }
}

