/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.MutableDateTime;

public class DateMathParser {
    private final FormatDateTimeFormatter dateTimeFormatter;
    private final TimeUnit timeUnit;

    public DateMathParser(FormatDateTimeFormatter dateTimeFormatter, TimeUnit timeUnit) {
        this.dateTimeFormatter = dateTimeFormatter;
        this.timeUnit = timeUnit;
    }

    public long parse(String text2, long now) {
        return this.parse(text2, now, false);
    }

    public long parseRoundCeil(String text2, long now) {
        return this.parse(text2, now, true);
    }

    public long parse(String text2, long now, boolean roundCeil) {
        String mathString;
        long time;
        if (text2.startsWith("now")) {
            time = now;
            mathString = text2.substring("now".length());
        } else {
            String parseString;
            int index = text2.indexOf("||");
            if (index == -1) {
                parseString = text2;
                mathString = "";
            } else {
                parseString = text2.substring(0, index);
                mathString = text2.substring(index + 2);
            }
            time = roundCeil ? this.parseRoundCeilStringValue(parseString) : this.parseStringValue(parseString);
        }
        if (mathString.isEmpty()) {
            return time;
        }
        return this.parseMath(mathString, time, roundCeil);
    }

    private long parseMath(String mathString, long time, boolean roundUp) throws ElasticSearchParseException {
        MutableDateTime dateTime = new MutableDateTime(time, DateTimeZone.UTC);
        try {
            int i = 0;
            block11: while (i < mathString.length()) {
                int num;
                int type;
                char c;
                if ((c = mathString.charAt(i++)) == '/') {
                    type = 0;
                } else if (c == '+') {
                    type = 1;
                } else if (c == '-') {
                    type = 2;
                } else {
                    throw new ElasticSearchParseException("operator not supported for date math [" + mathString + "]");
                }
                if (!Character.isDigit(mathString.charAt(i))) {
                    num = 1;
                } else {
                    int numFrom = i;
                    while (Character.isDigit(mathString.charAt(i))) {
                        ++i;
                    }
                    num = Integer.parseInt(mathString.substring(numFrom, i));
                }
                if (type == 0 && num != 1) {
                    throw new ElasticSearchParseException("rounding `/` can only be used on single unit types [" + mathString + "]");
                }
                char unit = mathString.charAt(i++);
                switch (unit) {
                    case 'y': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.yearOfCentury().roundCeiling();
                                continue block11;
                            }
                            dateTime.yearOfCentury().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addYears(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addYears(-num);
                        continue block11;
                    }
                    case 'M': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.monthOfYear().roundCeiling();
                                continue block11;
                            }
                            dateTime.monthOfYear().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addMonths(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addMonths(-num);
                        continue block11;
                    }
                    case 'w': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.weekOfWeekyear().roundCeiling();
                                continue block11;
                            }
                            dateTime.weekOfWeekyear().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addWeeks(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addWeeks(-num);
                        continue block11;
                    }
                    case 'd': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.dayOfMonth().roundCeiling();
                                continue block11;
                            }
                            dateTime.dayOfMonth().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addDays(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addDays(-num);
                        continue block11;
                    }
                    case 'H': 
                    case 'h': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.hourOfDay().roundCeiling();
                                continue block11;
                            }
                            dateTime.hourOfDay().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addHours(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addHours(-num);
                        continue block11;
                    }
                    case 'm': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.minuteOfHour().roundCeiling();
                                continue block11;
                            }
                            dateTime.minuteOfHour().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addMinutes(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addMinutes(-num);
                        continue block11;
                    }
                    case 's': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.secondOfMinute().roundCeiling();
                                continue block11;
                            }
                            dateTime.secondOfMinute().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addSeconds(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addSeconds(-num);
                        continue block11;
                    }
                }
                throw new ElasticSearchParseException("unit [" + unit + "] not supported for date math [" + mathString + "]");
            }
        }
        catch (Exception e) {
            if (e instanceof ElasticSearchParseException) {
                throw (ElasticSearchParseException)e;
            }
            throw new ElasticSearchParseException("failed to parse date math [" + mathString + "]");
        }
        return dateTime.getMillis();
    }

    private long parseStringValue(String value2) {
        try {
            return this.dateTimeFormatter.parser().parseMillis(value2);
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value2);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new ElasticSearchParseException("failed to parse date field [" + value2 + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number", e);
            }
        }
    }

    private long parseRoundCeilStringValue(String value2) {
        try {
            MutableDateTime dateTime = new MutableDateTime(1970, 1, 1, 23, 59, 59, 999, DateTimeZone.UTC);
            int location = this.dateTimeFormatter.parser().parseInto(dateTime, value2, 0);
            if (location == value2.length()) {
                return dateTime.getMillis();
            }
            if (location <= 0 || dateTime.getYear() > 5000) {
                try {
                    long time = Long.parseLong(value2);
                    return this.timeUnit.toMillis(time);
                }
                catch (NumberFormatException e1) {
                    throw new ElasticSearchParseException("failed to parse date field [" + value2 + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number");
                }
            }
            return dateTime.getMillis();
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value2);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new ElasticSearchParseException("failed to parse date field [" + value2 + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number", e);
            }
        }
    }
}

