/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.yaml;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.common.jackson.core.Base64Variant;
import org.elasticsearch.common.jackson.core.FormatSchema;
import org.elasticsearch.common.jackson.core.JsonGenerationException;
import org.elasticsearch.common.jackson.core.JsonGenerator;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.PrettyPrinter;
import org.elasticsearch.common.jackson.core.SerializableString;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.base.GeneratorBase;
import org.elasticsearch.common.jackson.core.io.IOContext;
import org.elasticsearch.common.jackson.dataformat.yaml.PackageVersion;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.DumperOptions;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.emitter.Emitter;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.AliasEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.DocumentEndEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.DocumentStartEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.ImplicitTuple;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.MappingEndEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.MappingStartEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.ScalarEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.SequenceEndEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.SequenceStartEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.StreamEndEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.StreamStartEvent;

public class YAMLGenerator
extends GeneratorBase {
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected final IOContext _ioContext;
    protected int _yamlFeatures;
    protected Writer _writer;
    protected DumperOptions _outputOptions;
    private static final Character STYLE_NAME = null;
    private static final Character STYLE_SCALAR = null;
    private static final Character STYLE_STRING = Character.valueOf('\"');
    private static final Character STYLE_BASE64 = Character.valueOf('\"');
    protected Emitter _emitter;
    protected String _objectId;
    protected String _typeId;
    private static final ImplicitTuple DEFAULT_IMPLICIT = new ImplicitTuple(true, true);

    public YAMLGenerator(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, Writer writer, DumperOptions.Version version) throws IOException {
        super(n, objectCodec);
        this._ioContext = iOContext;
        this._yamlFeatures = n2;
        this._writer = writer;
        this._emitter = new Emitter(this._writer, this._outputOptions());
        this._emitter.emit(new StreamStartEvent(null, null));
        Map<String, String> map2 = Collections.emptyMap();
        boolean bl = (Feature.WRITE_DOC_START_MARKER.getMask() & n2) != 0;
        this._emitter.emit(new DocumentStartEvent(null, null, bl, version, map2));
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public YAMLGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public YAMLGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this;
    }

    @Override
    public Object getOutputTarget() {
        return this._writer;
    }

    @Override
    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    @Override
    public final void writeFieldName(String string2) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(string2) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string2);
    }

    @Override
    public final void writeFieldName(SerializableString serializableString) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(serializableString.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString.getValue());
    }

    @Override
    public final void writeStringField(String string2, String string3) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(string2) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string2);
        this.writeString(string3);
    }

    private final void _writeFieldName(String string2) throws IOException, JsonGenerationException {
        this._writeScalar(string2, "string", STYLE_NAME);
    }

    public YAMLGenerator enable(Feature feature) {
        this._yamlFeatures |= feature.getMask();
        return this;
    }

    public YAMLGenerator disable(Feature feature) {
        this._yamlFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._yamlFeatures & feature.getMask()) != 0;
    }

    public YAMLGenerator configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    @Override
    public final void flush() throws IOException {
        this._writer.flush();
    }

    @Override
    public void close() throws IOException {
        this._emitter.emit(new DocumentEndEvent(null, null, false));
        this._emitter.emit(new StreamEndEvent(null, null));
        super.close();
        this._writer.close();
    }

    @Override
    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        Boolean bl = this._outputOptions().getDefaultFlowStyle().getStyleBoolean();
        String string2 = this._typeId;
        boolean bl2 = string2 == null;
        String string3 = this._objectId;
        if (string3 != null) {
            this._objectId = null;
        }
        this._emitter.emit(new SequenceStartEvent(string3, string2, bl2, null, null, bl));
    }

    @Override
    public final void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this._typeId = null;
        this._writeContext = this._writeContext.getParent();
        this._emitter.emit(new SequenceEndEvent(null, null));
    }

    @Override
    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        Boolean bl = this._outputOptions().getDefaultFlowStyle().getStyleBoolean();
        String string2 = this._typeId;
        boolean bl2 = string2 == null;
        String string3 = this._objectId;
        if (string3 != null) {
            this._objectId = null;
        }
        this._emitter.emit(new MappingStartEvent(string3, string2, bl2, null, null, bl));
    }

    @Override
    public final void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._typeId = null;
        this._writeContext = this._writeContext.getParent();
        this._emitter.emit(new MappingEndEvent(null, null));
    }

    @Override
    public void writeString(String string2) throws IOException, JsonGenerationException {
        if (string2 == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        this._writeScalar(string2, "string", STYLE_STRING);
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this.writeString(new String(cArray, n, n2));
    }

    @Override
    public final void writeString(SerializableString serializableString) throws IOException, JsonGenerationException {
        this.writeString(serializableString.toString());
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public final void writeUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.writeString(new String(byArray, n, n2, "UTF-8"));
    }

    @Override
    public void writeRaw(String string2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string2, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String string2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String string2, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (n > 0 || n + n2 != byArray.length) {
            byArray = Arrays.copyOfRange(byArray, n, n + n2);
        }
        String string2 = base64Variant.encode(byArray);
        this._writeScalar(string2, "byte[]", STYLE_BASE64);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        this._writeScalar(bl ? "true" : "false", "bool", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(int n) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(n), "int", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(long l) throws IOException, JsonGenerationException {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeNumber((int)l);
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(l), "long", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        if (bigInteger == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(bigInteger.toString()), "java.math.BigInteger", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(d), "double", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(float f2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(f2), "float", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        if (bigDecimal == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        String string2 = this.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? bigDecimal.toPlainString() : bigDecimal.toString();
        this._writeScalar(string2, "java.math.BigDecimal", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(String string2) throws IOException, JsonGenerationException, UnsupportedOperationException {
        if (string2 == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(string2, "number", STYLE_SCALAR);
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        this._writeScalar("null", "object", STYLE_SCALAR);
    }

    @Override
    public boolean canWriteObjectId() {
        return true;
    }

    @Override
    public boolean canWriteTypeId() {
        return true;
    }

    @Override
    public void writeTypeId(Object object) throws IOException, JsonGenerationException {
        this._typeId = String.valueOf(object);
    }

    @Override
    public void writeObjectRef(Object object) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write Object reference");
        AliasEvent aliasEvent = new AliasEvent(String.valueOf(object), null, null);
        this._emitter.emit(aliasEvent);
    }

    @Override
    public void writeObjectId(Object object) throws IOException, JsonGenerationException {
        this._objectId = String.valueOf(object);
    }

    @Override
    protected final void _verifyValueWrite(String string2) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeValue();
        if (n == 5) {
            this._reportError("Can not " + string2 + ", expecting field name");
        }
    }

    @Override
    protected void _releaseBuffers() {
    }

    protected void _writeScalar(String string2, String string3, Character c) throws IOException {
        this._emitter.emit(this._scalarEvent(string2, c));
    }

    protected ScalarEvent _scalarEvent(String string2, Character c) {
        String string3;
        String string4 = this._typeId;
        if (string4 != null) {
            this._typeId = null;
        }
        if ((string3 = this._objectId) != null) {
            this._objectId = null;
        }
        return new ScalarEvent(string3, string4, DEFAULT_IMPLICIT, string2, null, null, c);
    }

    protected DumperOptions _outputOptions() {
        if (this._outputOptions == null) {
            DumperOptions dumperOptions = new DumperOptions();
            if (this.isEnabled(Feature.CANONICAL_OUTPUT)) {
                dumperOptions.setCanonical(true);
            } else {
                dumperOptions.setCanonical(false);
                dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            }
            this._outputOptions = dumperOptions;
        }
        return this._outputOptions;
    }

    public static enum Feature {
        WRITE_DOC_START_MARKER(true),
        CANONICAL_OUTPUT(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

