/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.core.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.Versioned;

public class VersionUtil {
    private static final Pattern VERSION_SEPARATOR = Pattern.compile("[-_./;:]");
    private final Version _version;

    protected VersionUtil() {
        Version version = null;
        try {
            version = VersionUtil.versionFor(this.getClass());
        }
        catch (Exception exception) {
            System.err.println("ERROR: Failed to load Version information from " + this.getClass());
        }
        if (version == null) {
            version = Version.unknownVersion();
        }
        this._version = version;
    }

    public Version version() {
        return this._version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version versionFor(Class<?> clazz) {
        Version version = VersionUtil.packageVersionFor(clazz);
        if (version != null) {
            return version;
        }
        InputStream inputStream = clazz.getResourceAsStream("VERSION.txt");
        if (inputStream == null) {
            return Version.unknownVersion();
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            Version version2 = VersionUtil.doReadVersion(inputStreamReader);
            return version2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Version version3 = Version.unknownVersion();
            return version3;
        }
        finally {
            VersionUtil._close(inputStream);
        }
    }

    public static Version packageVersionFor(Class<?> clazz) {
        try {
            String string2 = clazz.getPackage().getName() + ".PackageVersion";
            Class<?> clazz2 = Class.forName(string2, true, clazz.getClassLoader());
            try {
                return ((Versioned)clazz2.newInstance()).version();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to get Versioned out of " + clazz2);
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Version doReadVersion(Reader reader) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            string2 = bufferedReader.readLine();
            if (string2 != null && (string3 = bufferedReader.readLine()) != null) {
                string4 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            VersionUtil._close(bufferedReader);
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (string4 != null) {
            string4 = string4.trim();
        }
        return VersionUtil.parseVersion(string2, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version mavenVersionFor(ClassLoader classLoader, String string2, String string3) {
        InputStream inputStream = classLoader.getResourceAsStream("META-INF/maven/" + string2.replaceAll("\\.", "/") + "/" + string3 + "/pom.properties");
        if (inputStream != null) {
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                String string4 = properties.getProperty("version");
                String string5 = properties.getProperty("artifactId");
                String string6 = properties.getProperty("groupId");
                Version version = VersionUtil.parseVersion(string4, string6, string5);
                return version;
            }
            catch (IOException iOException) {
            }
            finally {
                VersionUtil._close(inputStream);
            }
        }
        return Version.unknownVersion();
    }

    public static Version parseVersion(String string2, String string3, String string4) {
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            String[] stringArray = VERSION_SEPARATOR.split(string2);
            return new Version(VersionUtil.parseVersionPart(stringArray[0]), stringArray.length > 1 ? VersionUtil.parseVersionPart(stringArray[1]) : 0, stringArray.length > 2 ? VersionUtil.parseVersionPart(stringArray[2]) : 0, stringArray.length > 3 ? stringArray[3] : null, string3, string4);
        }
        return null;
    }

    protected static int parseVersionPart(String string2) {
        char c;
        int n = 0;
        int n2 = string2.length();
        for (int i = 0; i < n2 && (c = string2.charAt(i)) <= '9' && c >= '0'; ++i) {
            n = n * 10 + (c - 48);
        }
        return n;
    }

    private static final void _close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final void throwInternal() {
        throw new RuntimeException("Internal error: this code path should never get executed");
    }
}

