/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.core;

import java.io.IOException;
import org.elasticsearch.common.jackson.core.JsonLocation;

public class JsonProcessingException
extends IOException {
    static final long serialVersionUID = 123L;
    protected JsonLocation _location;

    protected JsonProcessingException(String string2, JsonLocation jsonLocation, Throwable throwable) {
        super(string2);
        if (throwable != null) {
            this.initCause(throwable);
        }
        this._location = jsonLocation;
    }

    protected JsonProcessingException(String string2) {
        super(string2);
    }

    protected JsonProcessingException(String string2, JsonLocation jsonLocation) {
        this(string2, jsonLocation, null);
    }

    protected JsonProcessingException(String string2, Throwable throwable) {
        this(string2, null, throwable);
    }

    protected JsonProcessingException(Throwable throwable) {
        this(null, null, throwable);
    }

    public JsonLocation getLocation() {
        return this._location;
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    protected String getMessageSuffix() {
        return null;
    }

    @Override
    public String getMessage() {
        String string2 = super.getMessage();
        if (string2 == null) {
            string2 = "N/A";
        }
        JsonLocation jsonLocation = this.getLocation();
        String string3 = this.getMessageSuffix();
        if (jsonLocation != null || string3 != null) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append(string2);
            if (string3 != null) {
                stringBuilder.append(string3);
            }
            if (jsonLocation != null) {
                stringBuilder.append('\n');
                stringBuilder.append(" at ");
                stringBuilder.append(jsonLocation.toString());
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }
}

