/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.core;

import org.elasticsearch.common.jackson.core.io.NumberInput;

public class JsonPointer {
    protected static final JsonPointer EMPTY = new JsonPointer();
    protected final JsonPointer _nextSegment;
    protected final String _asString;
    protected final String _matchingPropertyName;
    protected final int _matchingElementIndex;

    protected JsonPointer() {
        this._nextSegment = null;
        this._matchingPropertyName = "";
        this._matchingElementIndex = -1;
        this._asString = "";
    }

    protected JsonPointer(String string2, String string3, JsonPointer jsonPointer) {
        this._asString = string2;
        this._nextSegment = jsonPointer;
        this._matchingPropertyName = string3;
        this._matchingElementIndex = JsonPointer._parseInt(string3);
    }

    public static JsonPointer compile(String string2) throws IllegalArgumentException {
        if (string2 == null || string2.length() == 0) {
            return EMPTY;
        }
        if (string2.charAt(0) != '/') {
            throw new IllegalArgumentException("Invalid input: JSON Pointer expression must start with '/': \"" + string2 + "\"");
        }
        return JsonPointer._parseTail(string2);
    }

    public static JsonPointer valueOf(String string2) {
        return JsonPointer.compile(string2);
    }

    public boolean matches() {
        return this._nextSegment == null;
    }

    public String getMatchingProperty() {
        return this._matchingPropertyName;
    }

    public int getMatchingIndex() {
        return this._matchingElementIndex;
    }

    public boolean mayMatchProperty() {
        return this._matchingPropertyName != null;
    }

    public boolean mayMatchElement() {
        return this._matchingElementIndex >= 0;
    }

    public JsonPointer matchProperty(String string2) {
        if (this._nextSegment == null || !this._matchingPropertyName.equals(string2)) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer matchElement(int n) {
        if (n != this._matchingElementIndex || n < 0) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer tail() {
        return this._nextSegment;
    }

    public String toString() {
        return this._asString;
    }

    public int hashCode() {
        return this._asString.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonPointer)) {
            return false;
        }
        return this._asString.equals(((JsonPointer)object)._asString);
    }

    private static final int _parseInt(String string2) {
        int n = string2.length();
        if (n == 0) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            char c;
            if ((c = string2.charAt(i++)) <= '9' && c >= '0') continue;
            return -1;
        }
        return NumberInput.parseInt(string2);
    }

    protected static JsonPointer _parseTail(String string2) {
        int n = string2.length();
        int n2 = 1;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c == '/') {
                return new JsonPointer(string2, string2.substring(1, n2), JsonPointer._parseTail(string2.substring(n2)));
            }
            if (c != '~' || ++n2 >= n) continue;
            return JsonPointer._parseQuotedTail(string2, n2);
        }
        return new JsonPointer(string2, string2.substring(1), EMPTY);
    }

    protected static JsonPointer _parseQuotedTail(String string2, int n) {
        int n2 = string2.length();
        StringBuilder stringBuilder = new StringBuilder(Math.max(16, n2));
        if (n > 2) {
            stringBuilder.append(string2, 1, n - 1);
        }
        JsonPointer._appendEscape(stringBuilder, string2.charAt(n++));
        while (n < n2) {
            char c = string2.charAt(n);
            if (c == '/') {
                return new JsonPointer(string2, stringBuilder.toString(), JsonPointer._parseTail(string2.substring(n)));
            }
            if (c == '~' && ++n < n2) {
                JsonPointer._appendEscape(stringBuilder, string2.charAt(n++));
                continue;
            }
            stringBuilder.append(c);
        }
        return new JsonPointer(string2, stringBuilder.toString(), EMPTY);
    }

    private static void _appendEscape(StringBuilder stringBuilder, char c) {
        if (c == '0') {
            c = (char)126;
        } else if (c == '1') {
            c = (char)47;
        } else {
            stringBuilder.append('~');
        }
        stringBuilder.append(c);
    }
}

