/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.core;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.jackson.core.Base64Variant;
import org.elasticsearch.common.jackson.core.Base64Variants;
import org.elasticsearch.common.jackson.core.FormatSchema;
import org.elasticsearch.common.jackson.core.JsonGenerationException;
import org.elasticsearch.common.jackson.core.JsonParser;
import org.elasticsearch.common.jackson.core.JsonProcessingException;
import org.elasticsearch.common.jackson.core.JsonStreamContext;
import org.elasticsearch.common.jackson.core.JsonToken;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.PrettyPrinter;
import org.elasticsearch.common.jackson.core.SerializableString;
import org.elasticsearch.common.jackson.core.TreeNode;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.Versioned;
import org.elasticsearch.common.jackson.core.io.CharacterEscapes;
import org.elasticsearch.common.jackson.core.util.VersionUtil;

public abstract class JsonGenerator
implements Closeable,
Flushable,
Versioned {
    protected PrettyPrinter _cfgPrettyPrinter;

    protected JsonGenerator() {
    }

    public abstract JsonGenerator setCodec(ObjectCodec var1);

    public abstract ObjectCodec getCodec();

    @Override
    public abstract Version version();

    public Object getOutputTarget() {
        return null;
    }

    public abstract JsonGenerator enable(Feature var1);

    public abstract JsonGenerator disable(Feature var1);

    public final JsonGenerator configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public abstract boolean isEnabled(Feature var1);

    public abstract int getFeatureMask();

    public abstract JsonGenerator setFeatureMask(int var1);

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException("Generator of type " + this.getClass().getName() + " does not support schema of type '" + formatSchema.getSchemaType() + "'");
    }

    public FormatSchema getSchema() {
        return null;
    }

    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._cfgPrettyPrinter = prettyPrinter;
        return this;
    }

    public PrettyPrinter getPrettyPrinter() {
        return this._cfgPrettyPrinter;
    }

    public abstract JsonGenerator useDefaultPrettyPrinter();

    public JsonGenerator setHighestNonEscapedChar(int n) {
        return this;
    }

    public int getHighestEscapedChar() {
        return 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        return this;
    }

    public JsonGenerator setRootValueSeparator(SerializableString serializableString) {
        throw new UnsupportedOperationException();
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public boolean canWriteTypeId() {
        return false;
    }

    public boolean canWriteBinaryNatively() {
        return false;
    }

    public boolean canOmitFields() {
        return true;
    }

    public abstract void writeStartArray() throws IOException, JsonGenerationException;

    public abstract void writeEndArray() throws IOException, JsonGenerationException;

    public abstract void writeStartObject() throws IOException, JsonGenerationException;

    public abstract void writeEndObject() throws IOException, JsonGenerationException;

    public abstract void writeFieldName(String var1) throws IOException, JsonGenerationException;

    public abstract void writeFieldName(SerializableString var1) throws IOException, JsonGenerationException;

    public abstract void writeString(String var1) throws IOException, JsonGenerationException;

    public abstract void writeString(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeString(SerializableString var1) throws IOException, JsonGenerationException;

    public abstract void writeRawUTF8String(byte[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeUTF8String(byte[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(String var1) throws IOException, JsonGenerationException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(char var1) throws IOException, JsonGenerationException;

    public void writeRaw(SerializableString serializableString) throws IOException, JsonGenerationException {
        this.writeRaw(serializableString.getValue());
    }

    public abstract void writeRawValue(String var1) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(String var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeBinary(Base64Variant var1, byte[] var2, int var3, int var4) throws IOException, JsonGenerationException;

    public void writeBinary(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, n, n2);
    }

    public void writeBinary(byte[] byArray) throws IOException, JsonGenerationException {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, 0, byArray.length);
    }

    public int writeBinary(InputStream inputStream, int n) throws IOException, JsonGenerationException {
        return this.writeBinary(Base64Variants.getDefaultVariant(), inputStream, n);
    }

    public abstract int writeBinary(Base64Variant var1, InputStream var2, int var3) throws IOException, JsonGenerationException;

    public void writeNumber(short s) throws IOException, JsonGenerationException {
        this.writeNumber((int)s);
    }

    public abstract void writeNumber(int var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(long var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigInteger var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(double var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(float var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigDecimal var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(String var1) throws IOException, JsonGenerationException, UnsupportedOperationException;

    public abstract void writeBoolean(boolean var1) throws IOException, JsonGenerationException;

    public abstract void writeNull() throws IOException, JsonGenerationException;

    public void writeObjectId(Object object) throws IOException, JsonGenerationException {
        throw new JsonGenerationException("No native support for writing Object Ids");
    }

    public void writeObjectRef(Object object) throws IOException, JsonGenerationException {
        throw new JsonGenerationException("No native support for writing Object Ids");
    }

    public void writeTypeId(Object object) throws IOException, JsonGenerationException {
        throw new JsonGenerationException("No native support for writing Type Ids");
    }

    public abstract void writeObject(Object var1) throws IOException, JsonProcessingException;

    public abstract void writeTree(TreeNode var1) throws IOException, JsonProcessingException;

    public void writeStringField(String string2, String string3) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeString(string3);
    }

    public final void writeBooleanField(String string2, boolean bl) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeBoolean(bl);
    }

    public final void writeNullField(String string2) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeNull();
    }

    public final void writeNumberField(String string2, int n) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeNumber(n);
    }

    public final void writeNumberField(String string2, long l) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeNumber(l);
    }

    public final void writeNumberField(String string2, double d) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeNumber(d);
    }

    public final void writeNumberField(String string2, float f2) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeNumber(f2);
    }

    public final void writeNumberField(String string2, BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeNumber(bigDecimal);
    }

    public final void writeBinaryField(String string2, byte[] byArray) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeBinary(byArray);
    }

    public final void writeArrayFieldStart(String string2) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeStartArray();
    }

    public final void writeObjectFieldStart(String string2) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeStartObject();
    }

    public final void writeObjectField(String string2, Object object) throws IOException, JsonProcessingException {
        this.writeFieldName(string2);
        this.writeObject(object);
    }

    public void writeOmittedField(String string2) throws IOException, JsonGenerationException {
    }

    public void copyCurrentEvent(JsonParser jsonParser) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null) {
            this._reportError("No current event to copy");
        }
        switch (jsonToken.id()) {
            case -1: {
                this._reportError("No current event to copy");
            }
            case 1: {
                this.writeStartObject();
                break;
            }
            case 2: {
                this.writeEndObject();
                break;
            }
            case 3: {
                this.writeStartArray();
                break;
            }
            case 4: {
                this.writeEndArray();
                break;
            }
            case 5: {
                this.writeFieldName(jsonParser.getCurrentName());
                break;
            }
            case 6: {
                if (jsonParser.hasTextCharacters()) {
                    this.writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                    break;
                }
                this.writeString(jsonParser.getText());
                break;
            }
            case 7: {
                JsonParser.NumberType numberType = jsonParser.getNumberType();
                if (numberType == JsonParser.NumberType.INT) {
                    this.writeNumber(jsonParser.getIntValue());
                    break;
                }
                if (numberType == JsonParser.NumberType.BIG_INTEGER) {
                    this.writeNumber(jsonParser.getBigIntegerValue());
                    break;
                }
                this.writeNumber(jsonParser.getLongValue());
                break;
            }
            case 8: {
                JsonParser.NumberType numberType = jsonParser.getNumberType();
                if (numberType == JsonParser.NumberType.BIG_DECIMAL) {
                    this.writeNumber(jsonParser.getDecimalValue());
                    break;
                }
                if (numberType == JsonParser.NumberType.FLOAT) {
                    this.writeNumber(jsonParser.getFloatValue());
                    break;
                }
                this.writeNumber(jsonParser.getDoubleValue());
                break;
            }
            case 9: {
                this.writeBoolean(true);
                break;
            }
            case 10: {
                this.writeBoolean(false);
                break;
            }
            case 11: {
                this.writeNull();
                break;
            }
            case 12: {
                this.writeObject(jsonParser.getEmbeddedObject());
                break;
            }
            default: {
                this._throwInternal();
            }
        }
    }

    public void copyCurrentStructure(JsonParser jsonParser) throws IOException, JsonProcessingException {
        int n;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null) {
            this._reportError("No current event to copy");
        }
        if ((n = jsonToken.id()) == 5) {
            this.writeFieldName(jsonParser.getCurrentName());
            jsonToken = jsonParser.nextToken();
            n = jsonToken.id();
        }
        switch (n) {
            case 1: {
                this.writeStartObject();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndObject();
                break;
            }
            case 3: {
                this.writeStartArray();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndArray();
                break;
            }
            default: {
                this.copyCurrentEvent(jsonParser);
            }
        }
    }

    public abstract JsonStreamContext getOutputContext();

    @Override
    public abstract void flush() throws IOException;

    public abstract boolean isClosed();

    @Override
    public abstract void close() throws IOException;

    protected void _reportError(String string2) throws JsonGenerationException {
        throw new JsonGenerationException(string2);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Operation not supported by generator of type " + this.getClass().getName());
    }

    protected void _writeSimpleObject(Object object) throws IOException, JsonGenerationException {
        if (object == null) {
            this.writeNull();
            return;
        }
        if (object instanceof String) {
            this.writeString((String)object);
            return;
        }
        if (object instanceof Number) {
            Number number2 = (Number)object;
            if (number2 instanceof Integer) {
                this.writeNumber(number2.intValue());
                return;
            }
            if (number2 instanceof Long) {
                this.writeNumber(number2.longValue());
                return;
            }
            if (number2 instanceof Double) {
                this.writeNumber(number2.doubleValue());
                return;
            }
            if (number2 instanceof Float) {
                this.writeNumber(number2.floatValue());
                return;
            }
            if (number2 instanceof Short) {
                this.writeNumber(number2.shortValue());
                return;
            }
            if (number2 instanceof Byte) {
                this.writeNumber(number2.byteValue());
                return;
            }
            if (number2 instanceof BigInteger) {
                this.writeNumber((BigInteger)number2);
                return;
            }
            if (number2 instanceof BigDecimal) {
                this.writeNumber((BigDecimal)number2);
                return;
            }
            if (number2 instanceof AtomicInteger) {
                this.writeNumber(((AtomicInteger)number2).get());
                return;
            }
            if (number2 instanceof AtomicLong) {
                this.writeNumber(((AtomicLong)number2).get());
                return;
            }
        } else {
            if (object instanceof byte[]) {
                this.writeBinary((byte[])object);
                return;
            }
            if (object instanceof Boolean) {
                this.writeBoolean((Boolean)object);
                return;
            }
            if (object instanceof AtomicBoolean) {
                this.writeBoolean(((AtomicBoolean)object).get());
                return;
            }
        }
        throw new IllegalStateException("No ObjectCodec defined for the generator, can only serialize simple wrapper types (type passed " + object.getClass().getName() + ")");
    }

    public static enum Feature {
        AUTO_CLOSE_TARGET(true),
        AUTO_CLOSE_JSON_CONTENT(true),
        QUOTE_FIELD_NAMES(true),
        QUOTE_NON_NUMERIC_NUMBERS(true),
        WRITE_NUMBERS_AS_STRINGS(false),
        WRITE_BIGDECIMAL_AS_PLAIN(false),
        FLUSH_PASSED_TO_STREAM(true),
        ESCAPE_NON_ASCII(false),
        STRICT_DUPLICATE_DETECTION(false);

        private final boolean _defaultState;
        private final int _mask = 1 << this.ordinal();

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int n) {
            return (n & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

