/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.text.StringAndBytesText;
import org.elasticsearch.common.text.Text;

public abstract class StreamInput
extends InputStream {
    private static final ThreadLocal<SoftReference<char[]>> charCache = new ThreadLocal();
    private Version version = Version.CURRENT;

    private static char[] charCache(int size2) {
        char[] arr;
        SoftReference<char[]> ref = charCache.get();
        char[] cArray = arr = ref == null ? null : ref.get();
        if (arr == null || arr.length < size2) {
            arr = new char[ArrayUtil.oversize(size2, 2)];
            charCache.set(new SoftReference<char[]>(arr));
        }
        return arr;
    }

    public Version getVersion() {
        return this.version;
    }

    public StreamInput setVersion(Version version) {
        this.version = version;
        return this;
    }

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public BytesReference readBytesReference() throws IOException {
        int length = this.readVInt();
        return this.readBytesReference(length);
    }

    public BytesReference readBytesReference(int length) throws IOException {
        if (length == 0) {
            return BytesArray.EMPTY;
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesArray(bytes, 0, length);
    }

    public BytesRef readBytesRef() throws IOException {
        int length = this.readVInt();
        return this.readBytesRef(length);
    }

    public BytesRef readBytesRef(int length) throws IOException {
        if (length == 0) {
            return new BytesRef();
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesRef(bytes, 0, length);
    }

    public void readFully(byte[] b) throws IOException {
        this.readBytes(b, 0, b.length);
    }

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        assert ((b & 0x80) == 0);
        return i | (b & 0x7F) << 28;
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        assert ((b & 0x80) == 0);
        return i | ((long)b & 0x7FL) << 56;
    }

    @Nullable
    public Text readOptionalText() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        return new StringAndBytesText(this.readBytesReference(length));
    }

    public Text readText() throws IOException {
        int length = this.readInt();
        return new StringAndBytesText(this.readBytesReference(length));
    }

    public Text readSharedText() throws IOException {
        return this.readText();
    }

    @Nullable
    public String readOptionalString() throws IOException {
        if (this.readBoolean()) {
            return this.readString();
        }
        return null;
    }

    public String readString() throws IOException {
        int charCount = this.readVInt();
        char[] chars = StreamInput.charCache(charCount);
        int charIndex = 0;
        while (charIndex < charCount) {
            int c = this.readByte() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    chars[charIndex++] = (char)((c & 0x1F) << 6 | this.readByte() & 0x3F);
                    break;
                }
                case 14: {
                    chars[charIndex++] = (char)((c & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | (this.readByte() & 0x3F) << 0);
                }
            }
        }
        return new String(chars, 0, charCount);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Nullable
    public final Boolean readOptionalBoolean() throws IOException {
        byte val = this.readByte();
        if (val == 2) {
            return null;
        }
        if (val == 1) {
            return true;
        }
        return false;
    }

    @Override
    public abstract void reset() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public String[] readStringArray() throws IOException {
        int size2 = this.readVInt();
        if (size2 == 0) {
            return Strings.EMPTY_ARRAY;
        }
        String[] ret = new String[size2];
        for (int i = 0; i < size2; ++i) {
            ret[i] = this.readString();
        }
        return ret;
    }

    @Nullable
    public Map<String, Object> readMap() throws IOException {
        return (Map)this.readGenericValue();
    }

    @Nullable
    public Object readGenericValue() throws IOException {
        byte type = this.readByte();
        switch (type) {
            case -1: {
                return null;
            }
            case 0: {
                return this.readString();
            }
            case 1: {
                return this.readInt();
            }
            case 2: {
                return this.readLong();
            }
            case 3: {
                return Float.valueOf(this.readFloat());
            }
            case 4: {
                return this.readDouble();
            }
            case 5: {
                return this.readBoolean();
            }
            case 6: {
                int bytesSize = this.readVInt();
                byte[] value2 = new byte[bytesSize];
                this.readBytes(value2, 0, bytesSize);
                return value2;
            }
            case 7: {
                int size2 = this.readVInt();
                ArrayList<Object> list2 = new ArrayList<Object>(size2);
                for (int i = 0; i < size2; ++i) {
                    list2.add(this.readGenericValue());
                }
                return list2;
            }
            case 8: {
                int size8 = this.readVInt();
                Object[] list8 = new Object[size8];
                for (int i = 0; i < size8; ++i) {
                    list8[i] = this.readGenericValue();
                }
                return list8;
            }
            case 9: {
                int size9 = this.readVInt();
                LinkedHashMap<String, Object> map9 = new LinkedHashMap<String, Object>(size9);
                for (int i = 0; i < size9; ++i) {
                    map9.put(this.readString(), this.readGenericValue());
                }
                return map9;
            }
            case 10: {
                int size10 = this.readVInt();
                HashMap<String, Object> map10 = new HashMap<String, Object>(size10);
                for (int i = 0; i < size10; ++i) {
                    map10.put(this.readString(), this.readGenericValue());
                }
                return map10;
            }
            case 11: {
                return this.readByte();
            }
            case 12: {
                return new Date(this.readLong());
            }
            case 13: {
                return new DateTime(this.readLong());
            }
            case 14: {
                return this.readBytesReference();
            }
            case 15: {
                return this.readText();
            }
            case 16: {
                return this.readShort();
            }
            case 17: {
                return this.readPrimitiveIntArray();
            }
            case 18: {
                return this.readPrimitiveLongArray();
            }
            case 19: {
                return this.readPrimitiveFloatArray();
            }
            case 20: {
                return this.readPrimitiveDoubleArray();
            }
        }
        throw new IOException("Can't read unknown type [" + type + "]");
    }

    private Object readPrimitiveIntArray() throws IOException {
        int length = this.readVInt();
        int[] values2 = new int[length];
        for (int i = 0; i < length; ++i) {
            values2[i] = this.readInt();
        }
        return values2;
    }

    private Object readPrimitiveLongArray() throws IOException {
        int length = this.readVInt();
        long[] values2 = new long[length];
        for (int i = 0; i < length; ++i) {
            values2[i] = this.readLong();
        }
        return values2;
    }

    private Object readPrimitiveFloatArray() throws IOException {
        int length = this.readVInt();
        float[] values2 = new float[length];
        for (int i = 0; i < length; ++i) {
            values2[i] = this.readFloat();
        }
        return values2;
    }

    private Object readPrimitiveDoubleArray() throws IOException {
        int length = this.readVInt();
        double[] values2 = new double[length];
        for (int i = 0; i < length; ++i) {
            values2[i] = this.readDouble();
        }
        return values2;
    }
}

