/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.common.io.stream.AdapterStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.Text;

public class HandlesStreamOutput
extends AdapterStreamOutput {
    private static final int DEFAULT_IDENTITY_THRESHOLD = 50;
    private final int identityThreshold;
    private ObjectIntOpenHashMap<String> handles = new ObjectIntOpenHashMap();
    private HandleTable identityHandles = new HandleTable(10, 3.0f);
    private ObjectIntOpenHashMap<Text> handlesText = new ObjectIntOpenHashMap();

    public HandlesStreamOutput(StreamOutput out) {
        this(out, 50);
    }

    public HandlesStreamOutput(StreamOutput out, int identityThreshold) {
        super(out);
        this.identityThreshold = identityThreshold;
    }

    @Override
    public void writeString(String s) throws IOException {
        if (s.length() < this.identityThreshold) {
            if (!this.handles.containsKey(s)) {
                int handle2 = this.handles.size();
                this.handles.put(s, handle2);
                this.out.writeByte((byte)0);
                this.out.writeVInt(handle2);
                this.out.writeString(s);
            } else {
                this.out.writeByte((byte)1);
                this.out.writeVInt(this.handles.lget());
            }
        } else {
            int handle3 = this.identityHandles.lookup(s);
            if (handle3 == -1) {
                handle3 = this.identityHandles.assign(s);
                this.out.writeByte((byte)2);
                this.out.writeVInt(handle3);
                this.out.writeString(s);
            } else {
                this.out.writeByte((byte)3);
                this.out.writeVInt(handle3);
            }
        }
    }

    @Override
    public void writeSharedText(Text text2) throws IOException {
        int length = text2.hasBytes() ? text2.bytes().length() : text2.string().length();
        if (length < this.identityThreshold) {
            if (!this.handlesText.containsKey(text2)) {
                int handle2 = this.handlesText.size();
                this.handlesText.put(text2, handle2);
                this.out.writeByte((byte)0);
                this.out.writeVInt(handle2);
                this.out.writeText(text2);
            } else {
                this.out.writeByte((byte)1);
                this.out.writeVInt(this.handlesText.lget());
            }
        } else {
            this.out.writeByte((byte)2);
            this.out.writeText(text2);
        }
    }

    @Override
    public void reset() throws IOException {
        this.clear();
        if (this.out != null) {
            this.out.reset();
        }
    }

    public void clear() {
        this.handles.clear();
        if (this.identityHandles.capacity() > 10000) {
            this.identityHandles = new HandleTable(10, 3.0f);
        } else {
            this.identityHandles.clear();
        }
        this.handlesText.clear();
    }

    private static class HandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        HandleTable(int initialCapacity, float loadFactor) {
            this.loadFactor = loadFactor;
            this.spine = new int[initialCapacity];
            this.next = new int[initialCapacity];
            this.objs = new Object[initialCapacity];
            this.threshold = (int)((float)initialCapacity * loadFactor);
            this.clear();
        }

        public int capacity() {
            return this.spine.length;
        }

        int assign(Object obj) {
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
            }
            this.insert(obj, this.size);
            return this.size++;
        }

        int lookup(Object obj) {
            if (this.size == 0) {
                return -1;
            }
            int index = this.hash(obj) % this.spine.length;
            int i = this.spine[index];
            while (i >= 0) {
                if (this.objs[i] == obj) {
                    return i;
                }
                i = this.next[i];
            }
            return -1;
        }

        void clear() {
            Arrays.fill(this.spine, -1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void insert(Object obj, int handle2) {
            int index = this.hash(obj) % this.spine.length;
            this.objs[handle2] = obj;
            this.next[handle2] = this.spine[index];
            this.spine[index] = handle2;
        }

        private void growSpine() {
            this.spine = new int[(this.spine.length << 1) + 1];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            Arrays.fill(this.spine, -1);
            for (int i = 0; i < this.size; ++i) {
                this.insert(this.objs[i], i);
            }
        }

        private void growEntries() {
            int newLength = (this.next.length << 1) + 1;
            int[] newNext = new int[newLength];
            System.arraycopy(this.next, 0, newNext, 0, this.size);
            this.next = newNext;
            Object[] newObjs = new Object[newLength];
            System.arraycopy(this.objs, 0, newObjs, 0, this.size);
            this.objs = newObjs;
        }

        private int hash(Object obj) {
            return System.identityHashCode(obj) & Integer.MAX_VALUE;
        }
    }
}

