/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.common.hppc.IntObjectOpenHashMap;
import org.elasticsearch.common.io.stream.AdapterStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.text.Text;

public class HandlesStreamInput
extends AdapterStreamInput {
    private IntObjectOpenHashMap<String> handles = new IntObjectOpenHashMap();
    private IntObjectOpenHashMap<String> identityHandles = new IntObjectOpenHashMap();
    private IntObjectOpenHashMap<Text> handlesText = new IntObjectOpenHashMap();

    HandlesStreamInput() {
    }

    public HandlesStreamInput(StreamInput in) {
        super(in);
    }

    @Override
    public String readString() throws IOException {
        byte b = this.in.readByte();
        if (b == 0) {
            int handle2 = this.in.readVInt();
            String s = this.in.readString();
            this.handles.put(handle2, s);
            return s;
        }
        if (b == 1) {
            return this.handles.get(this.in.readVInt());
        }
        if (b == 2) {
            int handle3 = this.in.readVInt();
            String s = this.in.readString();
            this.identityHandles.put(handle3, s);
            return s;
        }
        if (b == 3) {
            return this.identityHandles.get(this.in.readVInt());
        }
        throw new IOException("Expected handle header, got [" + b + "]");
    }

    @Override
    public Text readSharedText() throws IOException {
        byte b = this.in.readByte();
        if (b == 0) {
            int handle2 = this.in.readVInt();
            Text s = this.in.readText();
            this.handlesText.put(handle2, s);
            return s;
        }
        if (b == 1) {
            return this.handlesText.get(this.in.readVInt());
        }
        if (b == 2) {
            return this.in.readText();
        }
        throw new IOException("Expected handle header, got [" + b + "]");
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.cleanHandles();
    }

    @Override
    public void reset(StreamInput in) {
        super.reset(in);
        this.cleanHandles();
    }

    public void cleanHandles() {
        this.handles.clear();
        this.handlesText.clear();
    }
}

