/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import org.elasticsearch.common.inject.AbstractProcessor;
import org.elasticsearch.common.inject.MembersInjectorImpl;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.spi.MembersInjectorLookup;
import org.elasticsearch.common.inject.spi.ProviderLookup;

class LookupProcessor
extends AbstractProcessor {
    LookupProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public <T> Boolean visit(MembersInjectorLookup<T> lookup2) {
        try {
            MembersInjectorImpl<T> membersInjector = this.injector.membersInjectorStore.get(lookup2.getType(), this.errors);
            lookup2.initializeDelegate(membersInjector);
        }
        catch (ErrorsException e) {
            this.errors.merge(e.getErrors());
        }
        return true;
    }

    @Override
    public <T> Boolean visit(ProviderLookup<T> lookup2) {
        try {
            Provider<T> provider = this.injector.getProviderOrThrow(lookup2.getKey(), this.errors);
            lookup2.initializeDelegate(provider);
        }
        catch (ErrorsException e) {
            this.errors.merge(e.getErrors());
        }
        return true;
    }
}

