/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Binding;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.matcher.Matcher;
import org.elasticsearch.common.inject.name.Names;
import org.elasticsearch.common.inject.spi.Message;

public class Injectors {
    public static Throwable getFirstErrorFailure(CreationException e) {
        if (e.getErrorMessages().isEmpty()) {
            return e;
        }
        for (Message message : e.getErrorMessages()) {
            if (message.getCause() == null) continue;
            return message.getCause();
        }
        return e;
    }

    public static <T> T getInstance(Injector injector, Class<T> type, String name) {
        return injector.getInstance(Key.get(type, (Annotation)Names.named(name)));
    }

    public static <T> Set<T> getInstancesOf(Injector injector, Class<T> baseClass) {
        HashSet<T> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry2 : entries) {
            Binding<?> binding;
            Object value2;
            Key<?> key = entry2.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !baseClass.isAssignableFrom(keyType) || (value2 = (binding = entry2.getValue()).getProvider().get()) == null) continue;
            T castValue = baseClass.cast(value2);
            answer.add(castValue);
        }
        return answer;
    }

    public static <T> Set<T> getInstancesOf(Injector injector, Matcher<Class> matcher) {
        HashSet<?> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry2 : entries) {
            Key<?> key = entry2.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !matcher.matches(keyType)) continue;
            Binding<?> binding = entry2.getValue();
            Object value2 = binding.getProvider().get();
            answer.add(value2);
        }
        return answer;
    }

    public static <T> Set<Provider<T>> getProvidersOf(Injector injector, Matcher<Class> matcher) {
        HashSet<Provider<T>> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry2 : entries) {
            Key<?> key = entry2.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !matcher.matches(keyType)) continue;
            Binding<?> binding = entry2.getValue();
            answer.add(binding.getProvider());
        }
        return answer;
    }

    public static <T> Set<Provider<T>> getProvidersOf(Injector injector, Class<T> baseClass) {
        HashSet<Provider<T>> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry2 : entries) {
            Key<?> key = entry2.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !baseClass.isAssignableFrom(keyType)) continue;
            Binding<?> binding = entry2.getValue();
            answer.add(binding.getProvider());
        }
        return answer;
    }

    public static boolean hasBinding(Injector injector, Matcher<Class> matcher) {
        return !Injectors.getBindingsOf(injector, matcher).isEmpty();
    }

    public static boolean hasBinding(Injector injector, Class<?> baseClass) {
        return !Injectors.getBindingsOf(injector, baseClass).isEmpty();
    }

    public static boolean hasBinding(Injector injector, Key<?> key) {
        Binding<?> binding = Injectors.getBinding(injector, key);
        return binding != null;
    }

    public static Binding<?> getBinding(Injector injector, Key<?> key) {
        Map<Key<?>, Binding<?>> bindings = injector.getBindings();
        Binding<?> binding = bindings.get(key);
        return binding;
    }

    public static Set<Binding<?>> getBindingsOf(Injector injector, Matcher<Class> matcher) {
        HashSet<Binding<?>> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry2 : entries) {
            Key<?> key = entry2.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !matcher.matches(keyType)) continue;
            answer.add(entry2.getValue());
        }
        return answer;
    }

    public static Set<Binding<?>> getBindingsOf(Injector injector, Class<?> baseClass) {
        HashSet<Binding<?>> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry2 : entries) {
            Key<?> key = entry2.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !baseClass.isAssignableFrom(keyType)) continue;
            answer.add(entry2.getValue());
        }
        return answer;
    }

    public static <T> Class<?> getKeyType(Key<?> key) {
        Class keyType = null;
        TypeLiteral<?> typeLiteral = key.getTypeLiteral();
        Type type = typeLiteral.getType();
        if (type instanceof Class) {
            keyType = (Class)type;
        }
        return keyType;
    }

    public static void close(Injector injector) {
    }

    public static void cleanCaches(Injector injector) {
        ((InjectorImpl)injector).clearCache();
        if (injector.getParent() != null) {
            Injectors.cleanCaches(injector.getParent());
        }
    }
}

