/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.common.hppc.AbstractIntCollection;
import org.elasticsearch.common.hppc.AbstractIterator;
import org.elasticsearch.common.hppc.AbstractObjectCollection;
import org.elasticsearch.common.hppc.HashContainerUtils;
import org.elasticsearch.common.hppc.IntContainer;
import org.elasticsearch.common.hppc.Internals;
import org.elasticsearch.common.hppc.ObjectContainer;
import org.elasticsearch.common.hppc.ObjectIntAssociativeContainer;
import org.elasticsearch.common.hppc.ObjectIntMap;
import org.elasticsearch.common.hppc.ObjectLookupContainer;
import org.elasticsearch.common.hppc.cursors.IntCursor;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.cursors.ObjectIntCursor;
import org.elasticsearch.common.hppc.predicates.IntPredicate;
import org.elasticsearch.common.hppc.predicates.ObjectPredicate;
import org.elasticsearch.common.hppc.procedures.IntProcedure;
import org.elasticsearch.common.hppc.procedures.ObjectIntProcedure;
import org.elasticsearch.common.hppc.procedures.ObjectProcedure;

public class ObjectIntOpenHashMap<KType>
implements ObjectIntMap<KType>,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public KType[] keys;
    public int[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public ObjectIntOpenHashMap() {
        this(16);
    }

    public ObjectIntOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ObjectIntOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public ObjectIntOpenHashMap(ObjectIntAssociativeContainer<KType> container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public int put(KType key, int value2) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                int oldValue = this.values[slot];
                this.values[slot] = value2;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value2, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value2;
        }
        return 0;
    }

    @Override
    public int putAll(ObjectIntAssociativeContainer<? extends KType> container) {
        int count2 = this.assigned;
        for (ObjectIntCursor<KType> objectIntCursor : container) {
            this.put(objectIntCursor.key, objectIntCursor.value);
        }
        return this.assigned - count2;
    }

    @Override
    public int putAll(Iterable<? extends ObjectIntCursor<? extends KType>> iterable) {
        int count2 = this.assigned;
        for (ObjectIntCursor<KType> objectIntCursor : iterable) {
            this.put(objectIntCursor.key, objectIntCursor.value);
        }
        return this.assigned - count2;
    }

    public boolean putIfAbsent(KType key, int value2) {
        if (!this.containsKey(key)) {
            this.put(key, value2);
            return true;
        }
        return false;
    }

    public int putOrAdd(KType key, int putValue, int additionValue) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                this.values[slot] = this.values[slot] + additionValue;
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, putValue, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = putValue;
        }
        return putValue;
    }

    public int addTo(KType key, int additionValue) {
        return this.putOrAdd(key, additionValue, additionValue);
    }

    private void expandAndPut(KType pendingKey, int pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        Object[] oldKeys = this.keys;
        int[] oldValues = this.values;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        KType[] keys = this.keys;
        int[] values2 = this.values;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            Object k = oldKeys[i];
            int v = oldValues[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
            values2[slot] = v;
        }
        Arrays.fill(oldKeys, null);
    }

    private void allocateBuffers(int capacity) {
        Object[] keys = (Object[])Internals.newArray(capacity);
        int[] values2 = new int[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.values = values2;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public int remove(KType key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                --this.assigned;
                int v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
        this.keys[slotPrev] = null;
    }

    @Override
    public int removeAll(ObjectContainer<? extends KType> container) {
        int before = this.assigned;
        for (ObjectCursor<KType> objectCursor : container) {
            this.remove(objectCursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int before = this.assigned;
        KType[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public int get(KType key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0;
    }

    @Override
    public int getOrDefault(KType key, int defaultValue) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return defaultValue;
    }

    public KType lkey() {
        return this.keys[this.lslot()];
    }

    public int lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public int lset(int key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        int previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        return this.lastSlot;
    }

    @Override
    public boolean containsKey(KType key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                this.lastSlot = slot;
                return true;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, null);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (ObjectIntCursor<KType> c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ObjectIntMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ObjectIntMap && (other = (ObjectIntMap)obj).size() == this.size()) {
                for (ObjectIntCursor<KType> c : this) {
                    int v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ObjectIntCursor<KType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ObjectIntProcedure<? super KType>> T forEach(T procedure) {
        KType[] keys = this.keys;
        int[] values2 = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values2[i]);
        }
        return procedure;
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public IntContainer values() {
        return new ValuesContainer();
    }

    public ObjectIntOpenHashMap<KType> clone() {
        try {
            ObjectIntOpenHashMap cloned = (ObjectIntOpenHashMap)super.clone();
            cloned.keys = (Object[])this.keys.clone();
            cloned.values = (int[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ObjectIntCursor<KType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <KType> ObjectIntOpenHashMap<KType> from(KType[] keys, int[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectIntOpenHashMap<KType> map2 = new ObjectIntOpenHashMap<KType>();
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }

    public static <KType> ObjectIntOpenHashMap<KType> from(ObjectIntAssociativeContainer<KType> container) {
        return new ObjectIntOpenHashMap<KType>(container);
    }

    public static <KType> ObjectIntOpenHashMap<KType> newInstance() {
        return new ObjectIntOpenHashMap<KType>();
    }

    public static <KType> ObjectIntOpenHashMap<KType> newInstanceWithoutPerturbations() {
        return new ObjectIntOpenHashMap<KType>(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static <KType> ObjectIntOpenHashMap<KType> newInstance(int initialCapacity, float loadFactor) {
        return new ObjectIntOpenHashMap<KType>(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            int max2 = ObjectIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max2 && !ObjectIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max2) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectIntOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return ObjectIntOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectIntOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(int value2) {
            boolean[] allocated = ObjectIntOpenHashMap.this.allocated;
            int[] values2 = ObjectIntOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value2 != values2[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            boolean[] allocated = ObjectIntOpenHashMap.this.allocated;
            int[] values2 = ObjectIntOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values2[i]);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            boolean[] allocated = ObjectIntOpenHashMap.this.allocated;
            int[] values2 = ObjectIntOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values2[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(int e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int i;
            int max2 = ObjectIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max2 && !ObjectIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max2) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectIntOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectIntOpenHashMap<KType> owner;

        public KeysContainer() {
            this.owner = ObjectIntOpenHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return ObjectIntOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            KType[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            KType[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(KType e) {
            boolean hasKey = this.owner.containsKey(e);
            int result2 = 0;
            if (hasKey) {
                this.owner.remove(e);
                result2 = 1;
            }
            return result2;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectIntCursor<KType>> {
        private final ObjectIntCursor<KType> cursor = new ObjectIntCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ObjectIntCursor<KType> fetch() {
            int i;
            int max2 = ObjectIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max2 && !ObjectIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max2) {
                return (ObjectIntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ObjectIntOpenHashMap.this.keys[i];
            this.cursor.value = ObjectIntOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

