/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.common.hppc.AbstractFloatCollection;
import org.elasticsearch.common.hppc.AbstractIntCollection;
import org.elasticsearch.common.hppc.AbstractIterator;
import org.elasticsearch.common.hppc.FloatContainer;
import org.elasticsearch.common.hppc.FloatIntAssociativeContainer;
import org.elasticsearch.common.hppc.FloatIntMap;
import org.elasticsearch.common.hppc.FloatLookupContainer;
import org.elasticsearch.common.hppc.HashContainerUtils;
import org.elasticsearch.common.hppc.IntContainer;
import org.elasticsearch.common.hppc.Internals;
import org.elasticsearch.common.hppc.cursors.FloatCursor;
import org.elasticsearch.common.hppc.cursors.FloatIntCursor;
import org.elasticsearch.common.hppc.cursors.IntCursor;
import org.elasticsearch.common.hppc.predicates.FloatPredicate;
import org.elasticsearch.common.hppc.predicates.IntPredicate;
import org.elasticsearch.common.hppc.procedures.FloatIntProcedure;
import org.elasticsearch.common.hppc.procedures.FloatProcedure;
import org.elasticsearch.common.hppc.procedures.IntProcedure;

public class FloatIntOpenHashMap
implements FloatIntMap,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public float[] keys;
    public int[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public FloatIntOpenHashMap() {
        this(16);
    }

    public FloatIntOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public FloatIntOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public FloatIntOpenHashMap(FloatIntAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public int put(float key, int value2) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                int oldValue = this.values[slot];
                this.values[slot] = value2;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value2, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value2;
        }
        return 0;
    }

    @Override
    public int putAll(FloatIntAssociativeContainer container) {
        int count2 = this.assigned;
        for (FloatIntCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count2;
    }

    @Override
    public int putAll(Iterable<? extends FloatIntCursor> iterable) {
        int count2 = this.assigned;
        for (FloatIntCursor floatIntCursor : iterable) {
            this.put(floatIntCursor.key, floatIntCursor.value);
        }
        return this.assigned - count2;
    }

    public boolean putIfAbsent(float key, int value2) {
        if (!this.containsKey(key)) {
            this.put(key, value2);
            return true;
        }
        return false;
    }

    public int putOrAdd(float key, int putValue, int additionValue) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.values[slot] = this.values[slot] + additionValue;
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, putValue, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = putValue;
        }
        return putValue;
    }

    public int addTo(float key, int additionValue) {
        return this.putOrAdd(key, additionValue, additionValue);
    }

    private void expandAndPut(float pendingKey, int pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        float[] oldKeys = this.keys;
        int[] oldValues = this.values;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        float[] keys = this.keys;
        int[] values2 = this.values;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            float k = oldKeys[i];
            int v = oldValues[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
            values2[slot] = v;
        }
    }

    private void allocateBuffers(int capacity) {
        float[] keys = new float[capacity];
        int[] values2 = new int[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.values = values2;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public int remove(float key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                int v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public int removeAll(FloatContainer container) {
        int before = this.assigned;
        for (FloatCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public int removeAll(FloatPredicate predicate) {
        int before = this.assigned;
        float[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public int get(float key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0;
    }

    @Override
    public int getOrDefault(float key, int defaultValue) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return defaultValue;
    }

    public int lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public int lset(int key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        int previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        return this.lastSlot;
    }

    @Override
    public boolean containsKey(float key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (FloatIntCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            FloatIntMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof FloatIntMap && (other = (FloatIntMap)obj).size() == this.size()) {
                for (FloatIntCursor c : this) {
                    int v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<FloatIntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends FloatIntProcedure> T forEach(T procedure) {
        float[] keys = this.keys;
        int[] values2 = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values2[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public IntContainer values() {
        return new ValuesContainer();
    }

    public FloatIntOpenHashMap clone() {
        try {
            FloatIntOpenHashMap cloned = (FloatIntOpenHashMap)super.clone();
            cloned.keys = (float[])this.keys.clone();
            cloned.values = (int[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (FloatIntCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static FloatIntOpenHashMap from(float[] keys, int[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatIntOpenHashMap map2 = new FloatIntOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }

    public static FloatIntOpenHashMap from(FloatIntAssociativeContainer container) {
        return new FloatIntOpenHashMap(container);
    }

    public static FloatIntOpenHashMap newInstance() {
        return new FloatIntOpenHashMap();
    }

    public static FloatIntOpenHashMap newInstanceWithoutPerturbations() {
        return new FloatIntOpenHashMap(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static FloatIntOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new FloatIntOpenHashMap(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            int max2 = FloatIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max2 && !FloatIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max2) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = FloatIntOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return FloatIntOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return FloatIntOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(int value2) {
            boolean[] allocated = FloatIntOpenHashMap.this.allocated;
            int[] values2 = FloatIntOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value2 != values2[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            boolean[] allocated = FloatIntOpenHashMap.this.allocated;
            int[] values2 = FloatIntOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values2[i]);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            boolean[] allocated = FloatIntOpenHashMap.this.allocated;
            int[] values2 = FloatIntOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values2[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(int e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            int max2 = FloatIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max2 && !FloatIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max2) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = FloatIntOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractFloatCollection
    implements FloatLookupContainer {
        private final FloatIntOpenHashMap owner;

        public KeysContainer() {
            this.owner = FloatIntOpenHashMap.this;
        }

        @Override
        public boolean contains(float e) {
            return FloatIntOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            float[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            float[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(float e) {
            boolean hasKey = this.owner.containsKey(e);
            int result2 = 0;
            if (hasKey) {
                this.owner.remove(e);
                result2 = 1;
            }
            return result2;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<FloatIntCursor> {
        private final FloatIntCursor cursor = new FloatIntCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected FloatIntCursor fetch() {
            int i;
            int max2 = FloatIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max2 && !FloatIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max2) {
                return (FloatIntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = FloatIntOpenHashMap.this.keys[i];
            this.cursor.value = FloatIntOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

