/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hppc;

import java.util.Arrays;
import org.elasticsearch.common.hppc.IntCollection;
import org.elasticsearch.common.hppc.IntLookupContainer;
import org.elasticsearch.common.hppc.cursors.IntCursor;
import org.elasticsearch.common.hppc.predicates.IntPredicate;

abstract class AbstractIntCollection
implements IntCollection {
    AbstractIntCollection() {
    }

    @Override
    public int removeAll(IntLookupContainer c) {
        final IntLookupContainer c2 = c;
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int k) {
                return c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(IntLookupContainer c) {
        final IntLookupContainer c2 = c;
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int k) {
                return !c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final IntPredicate predicate) {
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int value2) {
                return !predicate.apply(value2);
            }
        });
    }

    @Override
    public int[] toArray() {
        int size2 = this.size();
        int[] array = new int[size2];
        int i = 0;
        for (IntCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

