/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hppc;

import java.util.Arrays;
import org.elasticsearch.common.hppc.DoubleCollection;
import org.elasticsearch.common.hppc.DoubleLookupContainer;
import org.elasticsearch.common.hppc.cursors.DoubleCursor;
import org.elasticsearch.common.hppc.predicates.DoublePredicate;

abstract class AbstractDoubleCollection
implements DoubleCollection {
    AbstractDoubleCollection() {
    }

    @Override
    public int removeAll(DoubleLookupContainer c) {
        final DoubleLookupContainer c2 = c;
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double k) {
                return c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(DoubleLookupContainer c) {
        final DoubleLookupContainer c2 = c;
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double k) {
                return !c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final DoublePredicate predicate) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double value2) {
                return !predicate.apply(value2);
            }
        });
    }

    @Override
    public double[] toArray() {
        int size2 = this.size();
        double[] array = new double[size2];
        int i = 0;
        for (DoubleCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

