/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.impl.PointImpl;
import com.spatial4j.core.shape.impl.RectangleImpl;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.geo.GeoShapeConstants;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ShapeBuilder {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    private ShapeBuilder() {
    }

    public static Point newPoint(double lon, double lat) {
        return new PointImpl(lon, lat, GeoShapeConstants.SPATIAL_CONTEXT);
    }

    public static RectangleBuilder newRectangle() {
        return new RectangleBuilder();
    }

    public static PolygonBuilder newPolygon() {
        return new PolygonBuilder();
    }

    public static MultiPolygonBuilder newMultiPolygon() {
        return new MultiPolygonBuilder();
    }

    public static Geometry toJTSGeometry(Shape shape) {
        if (shape instanceof JtsGeometry) {
            return ((JtsGeometry)shape).getGeom();
        }
        if (shape instanceof JtsPoint) {
            return ((JtsPoint)shape).getGeom();
        }
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            if (rectangle.getCrossesDateLine()) {
                throw new IllegalArgumentException("Cannot convert Rectangles that cross the dateline into JTS Geometrys");
            }
            return ShapeBuilder.newPolygon().point(rectangle.getMinX(), rectangle.getMaxY()).point(rectangle.getMaxX(), rectangle.getMaxY()).point(rectangle.getMaxX(), rectangle.getMinY()).point(rectangle.getMinX(), rectangle.getMinY()).point(rectangle.getMinX(), rectangle.getMaxY()).toPolygon();
        }
        if (shape instanceof Point) {
            Point point = (Point)shape;
            return GEOMETRY_FACTORY.createPoint(new Coordinate(point.getX(), point.getY()));
        }
        throw new IllegalArgumentException("Shape type [" + shape.getClass().getSimpleName() + "] not supported");
    }

    public static class LinearRingBuilder<E> {
        private final E parent;
        private final List<Point> points = new ArrayList<Point>();

        private LinearRingBuilder(E parent) {
            this.parent = parent;
        }

        public LinearRingBuilder<E> point(double lon, double lat) {
            this.points.add(new PointImpl(lon, lat, GeoShapeConstants.SPATIAL_CONTEXT));
            return this;
        }

        protected Shape build() {
            return new JtsGeometry((Geometry)this.toLinearRing(), GeoShapeConstants.SPATIAL_CONTEXT, true);
        }

        protected LinearRing toLinearRing() {
            this.close();
            Coordinate[] coordinates = new Coordinate[this.points.size()];
            for (int i = 0; i < coordinates.length; ++i) {
                coordinates[i] = new Coordinate(this.points.get(i).getX(), this.points.get(i).getY());
            }
            return GEOMETRY_FACTORY.createLinearRing(coordinates);
        }

        public E close() {
            Point first = this.points.get(0);
            Point last2 = this.points.get(this.points.size() - 1);
            if (first.getX() != last2.getX() || first.getY() != last2.getY()) {
                this.points.add(first);
            }
            if (this.points.size() < 4) {
                throw new ElasticSearchIllegalArgumentException("A linear ring is defined by a least four points");
            }
            return this.parent;
        }

        public XContentBuilder toXContent(String name, XContentBuilder xcontent) throws IOException {
            if (name != null) {
                xcontent.startObject(name);
            } else {
                xcontent.startObject();
            }
            xcontent.field("type", "linestring");
            this.emdedXContent("coordinates", xcontent);
            xcontent.endObject();
            return xcontent;
        }

        protected void emdedXContent(String name, XContentBuilder xcontent) throws IOException {
            if (name != null) {
                xcontent.startArray(name);
            } else {
                xcontent.startArray();
            }
            for (Point point : this.points) {
                xcontent.startArray().value(point.getY()).value(point.getX()).endArray();
            }
            xcontent.endArray();
        }
    }

    public static class EmbededPolygonBuilder<E> {
        private final E parent;
        private final LinearRingBuilder<EmbededPolygonBuilder<E>> ring = new LinearRingBuilder(this);
        private final ArrayList<LinearRingBuilder<EmbededPolygonBuilder<E>>> holes = new ArrayList();

        private EmbededPolygonBuilder(E parent) {
            this.parent = parent;
        }

        public EmbededPolygonBuilder<E> point(double lon, double lat) {
            this.ring.point(lon, lat);
            return this;
        }

        public LinearRingBuilder<EmbededPolygonBuilder<E>> hole() {
            LinearRingBuilder<EmbededPolygonBuilder<E>> builder = new LinearRingBuilder<EmbededPolygonBuilder<E>>(this);
            this.holes.add(builder);
            return builder;
        }

        public Shape build() {
            return new JtsGeometry((Geometry)this.toPolygon(), GeoShapeConstants.SPATIAL_CONTEXT, true);
        }

        public Polygon toPolygon() {
            this.ring.close();
            LinearRing ring = this.ring.toLinearRing();
            LinearRing[] rings = new LinearRing[this.holes.size()];
            for (int i = 0; i < rings.length; ++i) {
                rings[i] = this.holes.get(i).toLinearRing();
            }
            return GEOMETRY_FACTORY.createPolygon(ring, rings);
        }

        public E close() {
            this.ring.close();
            return this.parent;
        }

        public XContentBuilder toXContent(String name, XContentBuilder xcontent) throws IOException {
            if (name != null) {
                xcontent.startObject(name);
            } else {
                xcontent.startObject();
            }
            xcontent.field("type", "polygon");
            this.emdedXContent("coordinates", xcontent);
            xcontent.endObject();
            return xcontent;
        }

        protected void emdedXContent(String name, XContentBuilder xcontent) throws IOException {
            if (name != null) {
                xcontent.startArray(name);
            } else {
                xcontent.startArray();
            }
            this.ring.emdedXContent(null, xcontent);
            for (LinearRingBuilder<EmbededPolygonBuilder<E>> ring : this.holes) {
                ring.emdedXContent(null, xcontent);
            }
            xcontent.endArray();
        }
    }

    public static class PolygonBuilder
    extends EmbededPolygonBuilder<PolygonBuilder> {
        private PolygonBuilder() {
            super(null);
        }

        @Override
        public PolygonBuilder close() {
            super.close();
            return this;
        }
    }

    public static class MultiPolygonBuilder {
        private final ArrayList<EmbededPolygonBuilder<MultiPolygonBuilder>> polygons = new ArrayList();

        public EmbededPolygonBuilder<MultiPolygonBuilder> polygon() {
            EmbededPolygonBuilder<MultiPolygonBuilder> builder = new EmbededPolygonBuilder<MultiPolygonBuilder>(this);
            this.polygons.add(builder);
            return builder;
        }

        public Shape build() {
            return new JtsGeometry((Geometry)this.toMultiPolygon(), GeoShapeConstants.SPATIAL_CONTEXT, true);
        }

        public MultiPolygon toMultiPolygon() {
            Polygon[] polygons = new Polygon[this.polygons.size()];
            for (int i = 0; i < polygons.length; ++i) {
                polygons[i] = this.polygons.get(i).toPolygon();
            }
            return GEOMETRY_FACTORY.createMultiPolygon(polygons);
        }

        public XContentBuilder toXContent(String name, XContentBuilder xcontent) throws IOException {
            if (name != null) {
                xcontent.startObject(name);
            } else {
                xcontent.startObject();
            }
            xcontent.field("type", "multipolygon");
            this.emdedXContent("coordinates", xcontent);
            xcontent.endObject();
            return xcontent;
        }

        protected void emdedXContent(String name, XContentBuilder xcontent) throws IOException {
            if (name != null) {
                xcontent.startArray(name);
            } else {
                xcontent.startArray();
            }
            for (EmbededPolygonBuilder<MultiPolygonBuilder> polygon : this.polygons) {
                polygon.emdedXContent(null, xcontent);
            }
            xcontent.endArray();
        }
    }

    public static class RectangleBuilder {
        private Point topLeft;
        private Point bottomRight;

        public RectangleBuilder topLeft(double lon, double lat) {
            this.topLeft = new PointImpl(lon, lat, GeoShapeConstants.SPATIAL_CONTEXT);
            return this;
        }

        public RectangleBuilder bottomRight(double lon, double lat) {
            this.bottomRight = new PointImpl(lon, lat, GeoShapeConstants.SPATIAL_CONTEXT);
            return this;
        }

        public Rectangle build() {
            return new RectangleImpl(this.topLeft.getX(), this.bottomRight.getX(), this.bottomRight.getY(), this.topLeft.getY(), GeoShapeConstants.SPATIAL_CONTEXT);
        }
    }
}

