/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;

public class GeoUtils {
    public static final double EARTH_SEMI_MAJOR_AXIS = 6378137.0;
    public static final double EARTH_SEMI_MINOR_AXIS = 6356752.314245;
    public static final double EARTH_MEAN_RADIUS = 6371008.7714;
    public static final double EARTH_AXIS_RATIO = 0.9966471893352243;
    public static final double EARTH_EQUATOR = 4.007501668557849E7;
    public static final double EARTH_POLAR_DISTANCE = 1.9970326371122006E7;

    public static double geoHashCellWidth(int level) {
        assert (level >= 0);
        return 4.007501668557849E7 / (double)(1L << (level + 1) / 2 * 3 + level / 2 * 2);
    }

    public static double quadTreeCellWidth(int level) {
        assert (level >= 0);
        return 4.007501668557849E7 / (double)(1L << level);
    }

    public static double geoHashCellHeight(int level) {
        assert (level >= 0);
        return 1.9970326371122006E7 / (double)(1L << (level + 1) / 2 * 2 + level / 2 * 3);
    }

    public static double quadTreeCellHeight(int level) {
        assert (level >= 0);
        return 1.9970326371122006E7 / (double)(1L << level);
    }

    public static double geoHashCellSize(int level) {
        assert (level >= 0);
        double w = GeoUtils.geoHashCellWidth(level);
        double h = GeoUtils.geoHashCellHeight(level);
        return Math.sqrt(w * w + h * h);
    }

    public static double quadTreeCellSize(int level) {
        assert (level >= 0);
        return Math.sqrt(2.0048208977185252E15) / (double)(1L << level);
    }

    public static int quadTreeLevelsForPrecision(double meters) {
        int level;
        assert (meters >= 0.0);
        if (meters == 0.0) {
            return 50;
        }
        double ratio = 1.4983235946676121;
        double width = Math.sqrt(meters * meters / 2.244973594337675);
        long part = Math.round(Math.ceil(4.007501668557849E7 / width));
        return part <= 1L << (level = 64 - Long.numberOfLeadingZeros(part) - 1) ? level : level + 1;
    }

    public static int quadTreeLevelsForPrecision(String distance) {
        return GeoUtils.quadTreeLevelsForPrecision(DistanceUnit.parse(distance, DistanceUnit.METERS, DistanceUnit.METERS));
    }

    public static int geoHashLevelsForPrecision(double meters) {
        int full;
        assert (meters >= 0.0);
        if (meters == 0.0) {
            return GeohashPrefixTree.getMaxLevelsPossible();
        }
        double ratio = 1.4983235946676121;
        double width = Math.sqrt(meters * meters / 2.244973594337675);
        double part = Math.ceil(4.007501668557849E7 / width);
        if (part == 1.0) {
            return 1;
        }
        int bits2 = (int)Math.round(Math.ceil(Math.log(part) / Math.log(2.0)));
        int left = bits2 - (full = bits2 / 5) * 5;
        int even = full + (left > 0 ? 1 : 0);
        int odd = full + (left > 3 ? 1 : 0);
        return even + odd;
    }

    public static int geoHashLevelsForPrecision(String distance) {
        return GeoUtils.geoHashLevelsForPrecision(DistanceUnit.parse(distance, DistanceUnit.METERS, DistanceUnit.METERS));
    }

    public static double normalizeLon(double lon) {
        return GeoUtils.centeredModulus(lon, 360.0);
    }

    public static double normalizeLat(double lat) {
        if ((lat = GeoUtils.centeredModulus(lat, 360.0)) < -90.0) {
            lat = -180.0 - lat;
        } else if (lat > 90.0) {
            lat = 180.0 - lat;
        }
        return lat;
    }

    public static void normalizePoint(GeoPoint point) {
        GeoUtils.normalizePoint(point, true, true);
    }

    public static void normalizePoint(GeoPoint point, boolean normLat, boolean normLon) {
        double lat = point.lat();
        double lon = point.lon();
        normLat = normLat && (lat > 90.0 || lat <= -90.0);
        boolean bl = normLon = normLon && (lon > 180.0 || lon <= -180.0);
        if (normLat) {
            lat = GeoUtils.centeredModulus(lat, 360.0);
            boolean shift = true;
            if (lat < -90.0) {
                lat = -180.0 - lat;
            } else if (lat > 90.0) {
                lat = 180.0 - lat;
            } else {
                shift = false;
            }
            if (shift) {
                lon = normLon ? (lon += 180.0) : (lon += GeoUtils.normalizeLon(lon) > 0.0 ? -180.0 : 180.0);
            }
        }
        if (normLon) {
            lon = GeoUtils.centeredModulus(lon, 360.0);
        }
        point.reset(lat, lon);
    }

    private static double centeredModulus(double dividend, double divisor) {
        double rtn = dividend % divisor;
        if (rtn <= 0.0) {
            rtn += divisor;
        }
        if (rtn > divisor / 2.0) {
            rtn -= divisor;
        }
        return rtn;
    }
}

