/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.xcontent.XContentParser;

public class GeoPoint {
    public static final String LATITUDE = "lat";
    public static final String LONGITUDE = "lon";
    private double lat;
    private double lon;

    public GeoPoint() {
    }

    public GeoPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public GeoPoint reset(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoPoint resetLat(double lat) {
        this.lat = lat;
        return this;
    }

    public GeoPoint resetLon(double lon) {
        this.lon = lon;
        return this;
    }

    public GeoPoint resetFromString(String value2) {
        int comma = value2.indexOf(44);
        if (comma != -1) {
            this.lat = Double.parseDouble(value2.substring(0, comma).trim());
            this.lon = Double.parseDouble(value2.substring(comma + 1).trim());
        } else {
            this.resetFromGeoHash(value2);
        }
        return this;
    }

    public GeoPoint resetFromGeoHash(String hash) {
        GeoHashUtils.decode(hash, this);
        return this;
    }

    void latlon(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public final double lat() {
        return this.lat;
    }

    public final double getLat() {
        return this.lat;
    }

    public final double lon() {
        return this.lon;
    }

    public final double getLon() {
        return this.lon;
    }

    public final String geohash() {
        return GeoHashUtils.encode(this.lat, this.lon);
    }

    public final String getGeohash() {
        return GeoHashUtils.encode(this.lat, this.lon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)o;
        if (Double.compare(geoPoint.lat, this.lat) != 0) {
            return false;
        }
        return Double.compare(geoPoint.lon, this.lon) == 0;
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result2 = (int)(temp ^ temp >>> 32);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    public String toString() {
        return "[" + this.lat + ", " + this.lon + "]";
    }

    public static GeoPoint parseFromLatLon(String latLon) {
        GeoPoint point = new GeoPoint();
        point.resetFromString(latLon);
        return point;
    }

    public static GeoPoint parse(XContentParser parser) throws IOException, ElasticSearchParseException {
        return GeoPoint.parse(parser, new GeoPoint());
    }

    public static GeoPoint parse(XContentParser parser, GeoPoint point) throws IOException, ElasticSearchParseException {
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                    String field2 = parser.text();
                    if (LATITUDE.equals(field2)) {
                        if (parser.nextToken() == XContentParser.Token.VALUE_NUMBER) {
                            point.resetLat(parser.doubleValue());
                            continue;
                        }
                        throw new ElasticSearchParseException("latitude must be a number");
                    }
                    if (LONGITUDE.equals(field2)) {
                        if (parser.nextToken() == XContentParser.Token.VALUE_NUMBER) {
                            point.resetLon(parser.doubleValue());
                            continue;
                        }
                        throw new ElasticSearchParseException("latitude must be a number");
                    }
                    throw new ElasticSearchParseException("field must be either 'lat' or 'lon'");
                }
                throw new ElasticSearchParseException("Token '" + (Object)((Object)parser.currentToken()) + "' not allowed");
            }
            return point;
        }
        if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
            int element = 0;
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                    if (++element == 1) {
                        point.resetLon(parser.doubleValue());
                        continue;
                    }
                    if (element == 2) {
                        point.resetLat(parser.doubleValue());
                        continue;
                    }
                    throw new ElasticSearchParseException("only two values allowed");
                }
                throw new ElasticSearchParseException("Numeric value expected");
            }
            return point;
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            String data2 = parser.text();
            int comma = data2.indexOf(44);
            if (comma > 0) {
                double lat = Double.parseDouble(data2.substring(0, comma).trim());
                double lon = Double.parseDouble(data2.substring(comma + 1).trim());
                return point.reset(lat, lon);
            }
            point.resetFromGeoHash(data2);
            return point;
        }
        throw new ElasticSearchParseException("geo_point expected");
    }
}

