/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.elasticsearch.common.compress.lzf.ChunkDecoder;
import org.elasticsearch.common.compress.lzf.LZFException;
import sun.misc.Unsafe;

public class UnsafeChunkDecoder
extends ChunkDecoder {
    private static final Unsafe unsafe;
    private static final long BYTE_ARRAY_OFFSET;

    public final int decodeChunk(InputStream is, byte[] inputBuffer, byte[] outputBuffer) throws IOException {
        int bytesRead = UnsafeChunkDecoder.readHeader(is, inputBuffer);
        if (bytesRead < 5 || inputBuffer[0] != 90 || inputBuffer[1] != 86) {
            if (bytesRead == 0) {
                return -1;
            }
            this._reportCorruptHeader();
        }
        byte type = inputBuffer[2];
        int compLen = UnsafeChunkDecoder.uint16(inputBuffer, 3);
        if (type == 0) {
            UnsafeChunkDecoder.readFully(is, false, outputBuffer, 0, compLen);
            return compLen;
        }
        UnsafeChunkDecoder.readFully(is, true, inputBuffer, 0, 2 + compLen);
        int uncompLen = UnsafeChunkDecoder.uint16(inputBuffer, 0);
        this.decodeChunk(inputBuffer, 2, outputBuffer, 0, uncompLen);
        return uncompLen;
    }

    public final void decodeChunk(byte[] in, int inPos, byte[] out, int outPos, int outEnd) throws IOException {
        block0: do {
            int ctrl = in[inPos++] & 0xFF;
            while (ctrl < 32) {
                UnsafeChunkDecoder.copyUpTo32(in, inPos, out, outPos, ctrl);
                inPos += ++ctrl;
                if ((outPos += ctrl) >= outEnd) break block0;
                ctrl = in[inPos++] & 0xFF;
            }
            int len = ctrl >> 5;
            ctrl = -((ctrl & 0x1F) << 8) - 1;
            if (len < 7) {
                if ((ctrl -= in[inPos++] & 0xFF) < -7) {
                    UnsafeChunkDecoder.moveLong(out, outPos, outEnd, ctrl);
                    outPos += len + 2;
                    continue;
                }
                outPos = this.copyOverlappingShort(out, outPos, ctrl, len);
                continue;
            }
            if ((ctrl -= in[inPos++] & 0xFF) + (len = in[inPos++] & 0xFF) >= -9) {
                outPos = UnsafeChunkDecoder.copyOverlappingLong(out, outPos, ctrl, len);
                continue;
            }
            if ((len += 9) <= 32) {
                UnsafeChunkDecoder.copyUpTo32(out, outPos + ctrl, out, outPos, len - 1);
            } else {
                System.arraycopy(out, outPos + ctrl, out, outPos, len);
            }
            outPos += len;
        } while (outPos < outEnd);
        if (outPos != outEnd) {
            throw new LZFException("Corrupt data: overrun in decompress, input offset " + inPos + ", output offset " + outPos);
        }
    }

    public int skipOrDecodeChunk(InputStream is, byte[] inputBuffer, byte[] outputBuffer, long maxToSkip) throws IOException {
        int bytesRead = UnsafeChunkDecoder.readHeader(is, inputBuffer);
        if (bytesRead < 5 || inputBuffer[0] != 90 || inputBuffer[1] != 86) {
            if (bytesRead == 0) {
                return -1;
            }
            this._reportCorruptHeader();
        }
        byte type = inputBuffer[2];
        int compLen = UnsafeChunkDecoder.uint16(inputBuffer, 3);
        if (type == 0) {
            if ((long)compLen <= maxToSkip) {
                UnsafeChunkDecoder.skipFully(is, compLen);
                return compLen;
            }
            UnsafeChunkDecoder.readFully(is, false, outputBuffer, 0, compLen);
            return -(compLen + 1);
        }
        UnsafeChunkDecoder.readFully(is, true, inputBuffer, 0, 2);
        int uncompLen = UnsafeChunkDecoder.uint16(inputBuffer, 0);
        if ((long)uncompLen <= maxToSkip) {
            UnsafeChunkDecoder.skipFully(is, compLen);
            return uncompLen;
        }
        UnsafeChunkDecoder.readFully(is, true, inputBuffer, 2, compLen);
        this.decodeChunk(inputBuffer, 2, outputBuffer, 0, uncompLen);
        return -(uncompLen + 1);
    }

    private final int copyOverlappingShort(byte[] out, int outPos, int offset, int len) {
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        switch (len) {
            case 6: {
                out[outPos] = out[outPos++ + offset];
            }
            case 5: {
                out[outPos] = out[outPos++ + offset];
            }
            case 4: {
                out[outPos] = out[outPos++ + offset];
            }
            case 3: {
                out[outPos] = out[outPos++ + offset];
            }
            case 2: {
                out[outPos] = out[outPos++ + offset];
            }
            case 1: {
                out[outPos] = out[outPos++ + offset];
            }
        }
        return outPos;
    }

    private static final int copyOverlappingLong(byte[] out, int outPos, int offset, int len) {
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        int end = (len += outPos) - 3;
        while (outPos < end) {
            out[outPos] = out[outPos++ + offset];
            out[outPos] = out[outPos++ + offset];
            out[outPos] = out[outPos++ + offset];
            out[outPos] = out[outPos++ + offset];
        }
        switch (len - outPos) {
            case 3: {
                out[outPos] = out[outPos++ + offset];
            }
            case 2: {
                out[outPos] = out[outPos++ + offset];
            }
            case 1: {
                out[outPos] = out[outPos++ + offset];
            }
        }
        return outPos;
    }

    private static final void moveLong(byte[] data2, int resultOffset, int dataEnd, int delta) {
        if (resultOffset + 8 < dataEnd) {
            long rawOffset = BYTE_ARRAY_OFFSET + (long)resultOffset;
            long value2 = unsafe.getLong(data2, rawOffset + (long)delta);
            unsafe.putLong(data2, rawOffset, value2);
            return;
        }
        System.arraycopy(data2, resultOffset + delta, data2, resultOffset, data2.length - resultOffset);
    }

    private static final void copyUpTo32(byte[] in, int inputIndex, byte[] out, int outputIndex, int lengthMinusOne) {
        if (outputIndex + 32 > out.length) {
            System.arraycopy(in, inputIndex, out, outputIndex, lengthMinusOne + 1);
            return;
        }
        long inPtr = BYTE_ARRAY_OFFSET + (long)inputIndex;
        long outPtr = BYTE_ARRAY_OFFSET + (long)outputIndex;
        switch (lengthMinusOne >>> 3) {
            case 3: {
                long value2 = unsafe.getLong(in, inPtr);
                unsafe.putLong(out, outPtr, value2);
                value2 = unsafe.getLong(in, inPtr += 8L);
                unsafe.putLong(out, outPtr += 8L, value2);
                value2 = unsafe.getLong(in, inPtr += 8L);
                unsafe.putLong(out, outPtr += 8L, value2);
                value2 = unsafe.getLong(in, inPtr += 8L);
                unsafe.putLong(out, outPtr += 8L, value2);
                break;
            }
            case 2: {
                long value3 = unsafe.getLong(in, inPtr);
                unsafe.putLong(out, outPtr, value3);
                value3 = unsafe.getLong(in, inPtr += 8L);
                unsafe.putLong(out, outPtr += 8L, value3);
                value3 = unsafe.getLong(in, inPtr += 8L);
                unsafe.putLong(out, outPtr += 8L, value3);
                break;
            }
            case 1: {
                long value4 = unsafe.getLong(in, inPtr);
                unsafe.putLong(out, outPtr, value4);
                value4 = unsafe.getLong(in, inPtr += 8L);
                unsafe.putLong(out, outPtr += 8L, value4);
                break;
            }
            case 0: {
                long value5 = unsafe.getLong(in, inPtr);
                unsafe.putLong(out, outPtr, value5);
            }
        }
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        BYTE_ARRAY_OFFSET = unsafe.arrayBaseOffset(byte[].class);
    }
}

