/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import org.elasticsearch.common.compress.lzf.ChunkEncoder;
import org.elasticsearch.common.compress.lzf.LZFChunk;

public class LZFEncoder {
    private LZFEncoder() {
    }

    public static byte[] encode(byte[] data2) throws IOException {
        return LZFEncoder.encode(data2, data2.length);
    }

    public static byte[] encode(byte[] data2, int length) throws IOException {
        return LZFEncoder.encode(data2, 0, length);
    }

    public static byte[] encode(byte[] data2, int offset, int length) throws IOException {
        ChunkEncoder enc = new ChunkEncoder(length);
        byte[] result2 = LZFEncoder.encode(enc, data2, offset, length);
        enc.close();
        return result2;
    }

    public static byte[] encode(ChunkEncoder enc, byte[] data2, int length) throws IOException {
        return LZFEncoder.encode(enc, data2, 0, length);
    }

    public static byte[] encode(ChunkEncoder enc, byte[] data2, int offset, int length) throws IOException {
        int left = length;
        int chunkLen = Math.min(65535, left);
        LZFChunk first = enc.encodeChunk(data2, offset, chunkLen);
        if ((left -= chunkLen) < 1) {
            return first.getData();
        }
        int resultBytes = first.length();
        offset += chunkLen;
        LZFChunk last2 = first;
        do {
            chunkLen = Math.min(left, 65535);
            LZFChunk chunk = enc.encodeChunk(data2, offset, chunkLen);
            offset += chunkLen;
            resultBytes += chunk.length();
            last2.setNext(chunk);
            last2 = chunk;
        } while ((left -= chunkLen) > 0);
        byte[] result2 = new byte[resultBytes];
        int ptr = 0;
        while (first != null) {
            ptr = first.copyTo(result2, ptr);
            first = first.next();
        }
        return result2;
    }
}

