/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.compress.CompressorContext;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class CompressedStreamOutput<T extends CompressorContext>
extends StreamOutput {
    private final StreamOutput out;
    protected final T context;
    protected byte[] uncompressed;
    protected int uncompressedLength;
    private int position = 0;
    private boolean closed;

    public CompressedStreamOutput(StreamOutput out, T context) throws IOException {
        this.out = out;
        this.context = context;
        super.setVersion(out.getVersion());
        this.writeHeader(out);
    }

    @Override
    public StreamOutput setVersion(Version version) {
        this.out.setVersion(version);
        return super.setVersion(version);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.position >= this.uncompressedLength) {
            this.flushBuffer();
        }
        this.uncompressed[this.position++] = (byte)b;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        if (this.position >= this.uncompressedLength) {
            this.flushBuffer();
        }
        this.uncompressed[this.position++] = b;
    }

    @Override
    public void writeBytes(byte[] input2, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int BUFFER_LEN = this.uncompressedLength;
        int free = BUFFER_LEN - this.position;
        if (free >= length) {
            System.arraycopy(input2, offset, this.uncompressed, this.position, length);
            this.position += length;
            return;
        }
        if (this.position > 0) {
            System.arraycopy(input2, offset, this.uncompressed, this.position, free);
            this.position += free;
            this.flushBuffer();
            offset += free;
            length -= free;
        }
        while (length >= BUFFER_LEN) {
            this.compress(input2, offset, BUFFER_LEN, this.out);
            offset += BUFFER_LEN;
            length -= BUFFER_LEN;
        }
        if (length > 0) {
            System.arraycopy(input2, offset, this.uncompressed, 0, length);
        }
        this.position = length;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flushBuffer();
            this.closed = true;
            this.doClose();
            this.out.close();
        }
    }

    protected abstract void doClose() throws IOException;

    @Override
    public void reset() throws IOException {
        this.position = 0;
        this.out.reset();
    }

    private void flushBuffer() throws IOException {
        if (this.position > 0) {
            this.compress(this.uncompressed, 0, this.position, this.out);
            this.position = 0;
        }
    }

    protected abstract void writeHeader(StreamOutput var1) throws IOException;

    protected abstract void compress(byte[] var1, int var2, int var3, StreamOutput var4) throws IOException;
}

