/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.base.Function;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.MapMaker;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;

@GwtCompatible(emulated=true)
class Platform {
    static <T> T[] newArray(T[] reference, int length) {
        Class<?> type = reference.getClass().getComponentType();
        Object[] result2 = (Object[])Array.newInstance(type, length);
        return result2;
    }

    static <E> Set<E> newSetFromMap(Map<E, Boolean> map2) {
        return Collections.newSetFromMap(map2);
    }

    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    static <K, V1, V2> SortedMap<K, V2> mapsTransformEntriesSortedMap(SortedMap<K, V1> fromMap, Maps.EntryTransformer<? super K, ? super V1, V2> transformer) {
        return fromMap instanceof NavigableMap ? Maps.transformEntries((NavigableMap)fromMap, transformer) : Maps.transformEntriesIgnoreNavigable(fromMap, transformer);
    }

    static <K, V> SortedMap<K, V> mapsAsMapSortedSet(SortedSet<K> set, Function<? super K, V> function) {
        return set instanceof NavigableSet ? Maps.asMap((NavigableSet)set, function) : Maps.asMapSortedIgnoreNavigable(set, function);
    }

    static <E> SortedSet<E> setsFilterSortedSet(SortedSet<E> set, Predicate<? super E> predicate) {
        return set instanceof NavigableSet ? Sets.filter((NavigableSet)set, predicate) : Sets.filterSortedIgnoreNavigable(set, predicate);
    }

    static <K, V> SortedMap<K, V> mapsFilterSortedMap(SortedMap<K, V> map2, Predicate<? super Map.Entry<K, V>> predicate) {
        return map2 instanceof NavigableMap ? Maps.filterEntries((NavigableMap)map2, predicate) : Maps.filterSortedIgnoreNavigable(map2, predicate);
    }

    private Platform() {
    }
}

