/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.hppc.IntCollection;
import org.elasticsearch.common.hppc.IntContainer;
import org.elasticsearch.common.hppc.IntLookupContainer;
import org.elasticsearch.common.hppc.IntObjectAssociativeContainer;
import org.elasticsearch.common.hppc.IntObjectMap;
import org.elasticsearch.common.hppc.IntObjectOpenHashMap;
import org.elasticsearch.common.hppc.ObjectContainer;
import org.elasticsearch.common.hppc.cursors.IntCursor;
import org.elasticsearch.common.hppc.cursors.IntObjectCursor;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.predicates.IntPredicate;
import org.elasticsearch.common.hppc.procedures.IntObjectProcedure;

public final class ImmutableOpenIntMap<VType>
implements Iterable<IntObjectCursor<VType>> {
    private final IntObjectOpenHashMap<VType> map;
    private static final ImmutableOpenIntMap EMPTY = new ImmutableOpenIntMap(new IntObjectOpenHashMap());

    private ImmutableOpenIntMap(IntObjectOpenHashMap<VType> map2) {
        this.map = map2;
    }

    public VType get(int key) {
        return this.map.get(key);
    }

    public boolean containsKey(int key) {
        return this.map.containsKey(key);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<IntObjectCursor<VType>> iterator() {
        return this.map.iterator();
    }

    public IntLookupContainer keys() {
        return this.map.keys();
    }

    public UnmodifiableIterator<Integer> keysIt() {
        final Iterator<IntCursor> iterator2 = this.map.keys().iterator();
        return new UnmodifiableIterator<Integer>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public Integer next() {
                return ((IntCursor)iterator2.next()).value;
            }
        };
    }

    public ObjectContainer<VType> values() {
        return this.map.values();
    }

    public UnmodifiableIterator<VType> valuesIt() {
        final Iterator<ObjectCursor<VType>> iterator2 = this.map.values().iterator();
        return new UnmodifiableIterator<VType>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public VType next() {
                return ((ObjectCursor)iterator2.next()).value;
            }
        };
    }

    public String toString() {
        return this.map.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableOpenIntMap that = (ImmutableOpenIntMap)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public static <VType> ImmutableOpenIntMap<VType> of() {
        return EMPTY;
    }

    public static <VType> Builder<VType> builder() {
        return new Builder();
    }

    public static <VType> Builder<VType> builder(int size2) {
        return new Builder(size2);
    }

    public static <VType> Builder<VType> builder(ImmutableOpenIntMap<VType> map2) {
        return new Builder<VType>(map2);
    }

    public static class Builder<VType>
    implements IntObjectMap<VType> {
        private IntObjectOpenHashMap<VType> map;

        public Builder() {
            this(EMPTY);
        }

        public Builder(int size2) {
            this.map = new IntObjectOpenHashMap(size2);
        }

        public Builder(ImmutableOpenIntMap<VType> map2) {
            this.map = ((ImmutableOpenIntMap)map2).map.clone();
        }

        public ImmutableOpenIntMap<VType> build() {
            IntObjectOpenHashMap<VType> map2 = this.map;
            this.map = null;
            return new ImmutableOpenIntMap(map2);
        }

        public Builder<VType> putAll(Map<Integer, VType> map2) {
            for (Map.Entry<Integer, VType> entry2 : map2.entrySet()) {
                this.map.put(entry2.getKey(), entry2.getValue());
            }
            return this;
        }

        public Builder<VType> fPut(int key, VType value2) {
            this.map.put(key, value2);
            return this;
        }

        @Override
        public VType put(int key, VType value2) {
            return this.map.put(key, value2);
        }

        @Override
        public VType get(int key) {
            return this.map.get(key);
        }

        @Override
        public VType getOrDefault(int kType, VType vType) {
            return this.map.getOrDefault(kType, vType);
        }

        public Builder<VType> fRemove(int key) {
            this.map.remove(key);
            return this;
        }

        @Override
        public VType remove(int key) {
            return this.map.remove(key);
        }

        @Override
        public Iterator<IntObjectCursor<VType>> iterator() {
            return this.map.iterator();
        }

        @Override
        public boolean containsKey(int key) {
            return this.map.containsKey(key);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public int putAll(IntObjectAssociativeContainer<? extends VType> container) {
            return this.map.putAll(container);
        }

        @Override
        public int putAll(Iterable<? extends IntObjectCursor<? extends VType>> iterable) {
            return this.map.putAll(iterable);
        }

        @Override
        public int removeAll(IntContainer container) {
            return this.map.removeAll(container);
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            return this.map.removeAll(predicate);
        }

        @Override
        public <T extends IntObjectProcedure<? super VType>> T forEach(T procedure) {
            return this.map.forEach(procedure);
        }

        @Override
        public IntCollection keys() {
            return this.map.keys();
        }

        @Override
        public ObjectContainer<VType> values() {
            return this.map.values();
        }
    }
}

