/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

public class BoundedTreeSet<E>
extends TreeSet<E> {
    private final int size;

    public BoundedTreeSet(int size2) {
        this.size = size2;
    }

    public BoundedTreeSet(Comparator<? super E> comparator, int size2) {
        super(comparator);
        this.size = size2;
    }

    @Override
    public boolean add(E e) {
        boolean result2 = super.add(e);
        this.rebound();
        return result2;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result2 = super.addAll(c);
        this.rebound();
        return result2;
    }

    private void rebound() {
        while (this.size() > this.size) {
            this.remove(this.last());
        }
    }
}

